/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.async;

import java.util.concurrent.Callable;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;

public class SWCallable<V>
implements Callable<V> {
    private static final String OPERATION_NAME = "SpringAsync";
    private Callable<V> callable;
    private ContextSnapshot snapshot;

    SWCallable(Callable<V> callable, ContextSnapshot snapshot) {
        this.callable = callable;
        this.snapshot = snapshot;
    }

    @Override
    public V call() throws Exception {
        AbstractSpan span = ContextManager.createLocalSpan((String)OPERATION_NAME);
        span.setComponent((Component)ComponentsDefine.SPRING_ASYNC);
        try {
            ContextManager.continued((ContextSnapshot)this.snapshot);
            V v = this.callable.call();
            return v;
        }
        catch (Exception e) {
            ContextManager.activeSpan().errorOccurred().log((Throwable)e);
            throw e;
        }
        finally {
            ContextManager.stopSpan();
        }
    }
}

