/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v5;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceConstructorInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.v5.Constants;
import org.apache.skywalking.apm.plugin.elasticsearch.v5.ElasticSearchEnhanceInfo;
import org.apache.skywalking.apm.plugin.elasticsearch.v5.Util;
import org.elasticsearch.cluster.node.DiscoveryNode;

public class TransportActionNodeProxyInterceptor
implements InstanceConstructorInterceptor,
InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        ElasticSearchEnhanceInfo enhanceInfo = (ElasticSearchEnhanceInfo)((EnhancedInstance)objInst.getSkyWalkingDynamicField()).getSkyWalkingDynamicField();
        String opType = allArguments[1].getClass().getSimpleName();
        String operationName = "Elasticsearch/" + opType;
        AbstractSpan span = ContextManager.createExitSpan((String)operationName, (String)enhanceInfo.transportAddresses());
        span.setComponent((Component)ComponentsDefine.TRANSPORT_CLIENT);
        Tags.DB_TYPE.set(span, "Elasticsearch");
        Tags.DB_INSTANCE.set(span, enhanceInfo.getClusterName());
        if (Config.Plugin.Elasticsearch.TRACE_DSL) {
            Tags.DB_STATEMENT.set(span, enhanceInfo.getSource());
        }
        span.tag(Constants.ES_NODE, ((DiscoveryNode)allArguments[0]).getAddress().toString());
        span.tag(Constants.ES_INDEX, Util.wrapperNullStringValue(enhanceInfo.getIndices()));
        span.tag(Constants.ES_TYPE, Util.wrapperNullStringValue(enhanceInfo.getTypes()));
        SpanLayer.asDB((AbstractSpan)span);
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }

    public void onConstruct(EnhancedInstance objInst, Object[] allArguments) {
        EnhancedInstance actions = (EnhancedInstance)allArguments[1];
        objInst.setSkyWalkingDynamicField((Object)actions);
    }
}

