/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.elasticsearch.v5;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.elasticsearch.v5.Constants;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchResponse;

public class PlainListenableActionFutureInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        AbstractSpan span = ContextManager.createLocalSpan((String)"Elasticsearch/actionGet");
        span.setComponent((Component)ComponentsDefine.TRANSPORT_CLIENT);
        Tags.DB_TYPE.set(span, "Elasticsearch");
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        AbstractSpan span = ContextManager.activeSpan();
        if (ret instanceof SearchResponse) {
            SearchResponse response = (SearchResponse)ret;
            span.tag(Constants.ES_TOOK_MILLIS, Long.toString(response.getTookInMillis()));
            span.tag(Constants.ES_TOTAL_HITS, Long.toString(response.getHits().getTotalHits()));
        } else if (ret instanceof BulkResponse) {
            BulkResponse response = (BulkResponse)ret;
            span.tag(Constants.ES_TOOK_MILLIS, Long.toString(response.getTookInMillis()));
            span.tag(Constants.ES_INGEST_TOOK_MILLIS, Long.toString(response.getIngestTookInMillis()));
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().errorOccurred().log(t);
    }
}

