/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.services;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.rss.Channel;
import com.sun.syndication.feed.rss.Item;
import com.sun.syndication.io.WireFeedInput;
import com.sun.syndication.io.XmlReader;
import java.awt.geom.Rectangle2D;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.sis.distance.DistanceUtils;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.geometry.Envelope2D;
import org.apache.sis.index.tree.GeoRSSData;
import org.apache.sis.index.tree.QuadTree;
import org.apache.sis.index.tree.QuadTreeData;
import org.apache.sis.index.tree.QuadTreeReader;
import org.apache.sis.index.tree.QuadTreeWriter;
import org.opengis.geometry.DirectPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocationServlet
extends HttpServlet {
    private static final long serialVersionUID = 731743219362175102L;
    private QuadTree tree;
    private ServletContext context;
    private String timeToLoad;
    private String qtreeIdxPath;
    private String georssStoragePath;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.context = servletConfig.getServletContext();
        long l = 0L;
        long l2 = 0L;
        int n = -1;
        int n2 = -1;
        this.qtreeIdxPath = this.context.getInitParameter("org.apache.sis.services.config.qIndexPath");
        this.georssStoragePath = this.context.getInitParameter("org.apache.sis.services.config.geodataPath");
        if (!this.qtreeIdxPath.endsWith("/")) {
            this.qtreeIdxPath = this.qtreeIdxPath + "/";
        }
        if (!this.georssStoragePath.endsWith("/")) {
            this.georssStoragePath = this.georssStoragePath + "/";
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.qtreeIdxPath + "node_0.txt");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("[INFO] Existing qtree index at: [" + this.qtreeIdxPath + "] not found. Creating new index.");
        }
        if (fileInputStream != null) {
            l = System.currentTimeMillis();
            this.tree = QuadTreeReader.readFromFile((String)this.qtreeIdxPath, (String)"tree_config.txt", (String)"node_0.txt");
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            l2 = System.currentTimeMillis();
            this.timeToLoad = "Quad Tree fully loaded from index files in " + Double.toString((l2 - l) / 1000L) + " seconds";
            System.out.println("[INFO] Finished loading tree from stored index");
        } else {
            l = System.currentTimeMillis();
            WireFeedInput wireFeedInput = new WireFeedInput(true);
            FileInputStream fileInputStream2 = null;
            try {
                fileInputStream2 = new FileInputStream(this.context.getInitParameter("org.apache.sis.services.config.filePath"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (fileInputStream2 != null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                try {
                    NodeList nodeList;
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(fileInputStream2);
                    NodeList nodeList2 = document.getElementsByTagName("capacity");
                    if (nodeList2.item(0) != null) {
                        n = Integer.parseInt(nodeList2.item(0).getFirstChild().getNodeValue());
                    }
                    if ((nodeList = document.getElementsByTagName("depth")).item(0) != null) {
                        n2 = Integer.parseInt(nodeList.item(0).getFirstChild().getNodeValue());
                    }
                    this.tree = new QuadTree(n, n2);
                    NodeList nodeList3 = document.getElementsByTagName("url");
                    for (int i = 0; i < nodeList3.getLength(); ++i) {
                        String string = nodeList3.item(i).getFirstChild().getNodeValue();
                        WireFeed wireFeed = null;
                        try {
                            wireFeed = wireFeedInput.build((Reader)new XmlReader(new URL(string)));
                        }
                        catch (Exception exception) {
                            System.out.println("[ERROR] Error obtaining geodata url: [" + string + "]: Message: " + exception.getMessage() + ": skipping and continuing");
                            continue;
                        }
                        Channel channel = (Channel)wireFeed;
                        List list = channel.getItems();
                        for (Item item : list) {
                            GeoRSSModule geoRSSModule = (GeoRSSModule)item.getModule("http://www.georss.org/georss");
                            if (geoRSSModule == null) {
                                geoRSSModule = (GeoRSSModule)item.getModule("http://www.opengis.net/gml");
                            }
                            if (geoRSSModule == null) {
                                geoRSSModule = (GeoRSSModule)item.getModule("http://www.w3.org/2003/01/geo/wgs84_pos#");
                            }
                            if (geoRSSModule == null || geoRSSModule.getPosition() == null) continue;
                            String string2 = "";
                            string2 = item.getGuid() != null ? LocationServlet.cleanStr((String)item.getGuid().getValue()) + ".txt" : LocationServlet.cleanStr((String)item.getLink()) + ".txt";
                            GeoRSSData geoRSSData = new GeoRSSData(string2, new DirectPosition2D(geoRSSModule.getPosition().getLongitude(), geoRSSModule.getPosition().getLatitude()));
                            if (this.tree.insert((QuadTreeData)geoRSSData)) {
                                geoRSSData.saveToFile(item, geoRSSModule, this.georssStoragePath);
                                continue;
                            }
                            System.out.println("[INFO] Unable to store data at location " + geoRSSData.getLatLon().y + ", " + geoRSSData.getLatLon().x + " under filename " + geoRSSData.getFileName());
                        }
                    }
                    ((InputStream)fileInputStream2).close();
                    l2 = System.currentTimeMillis();
                    this.timeToLoad = "Quad Tree fully loaded from retrieving GeoRSS files over the network in " + Double.toString((l2 - l) / 1000L) + " seconds";
                    QuadTreeWriter.writeTreeToFile((QuadTree)this.tree, (String)this.qtreeIdxPath);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    parserConfigurationException.printStackTrace();
                }
                catch (SAXException sAXException) {
                    sAXException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    illegalArgumentException.printStackTrace();
                }
            } else {
                throw new ServletException("Unable to read location service XML config: null!");
            }
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        long l = 0L;
        long l2 = 0L;
        httpServletResponse.setContentType("text/xml");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string2 = httpServletRequest.getParameter("type");
        List list = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null && string2.equals("bbox")) {
            string = httpServletRequest.getParameter("llLat");
            String string3 = httpServletRequest.getParameter("llLon");
            String string4 = httpServletRequest.getParameter("urLat");
            String string5 = httpServletRequest.getParameter("urLon");
            if (string != null && string3 != null && string4 != null && string5 != null) {
                try {
                    Envelope2D envelope2D = new Envelope2D((DirectPosition)new DirectPosition2D(Double.parseDouble(string3), Double.parseDouble(string)), (DirectPosition)new DirectPosition2D(Double.parseDouble(string5), Double.parseDouble(string4)));
                    l = System.currentTimeMillis();
                    list = this.tree.queryByBoundingBox(envelope2D);
                    l2 = System.currentTimeMillis();
                    Rectangle2D.Double[] doubleArray = envelope2D.toRectangles();
                    for (int i = 0; i < doubleArray.length; ++i) {
                        Rectangle2D.Double double_ = doubleArray[i];
                        String string6 = double_.getMinY() + "," + double_.getMinX() + ",";
                        string6 = string6 + double_.getMaxY() + "," + double_.getMinX() + ",";
                        string6 = string6 + double_.getMaxY() + "," + double_.getMaxX() + ",";
                        string6 = string6 + double_.getMinY() + "," + double_.getMaxX() + ",";
                        string6 = string6 + double_.getMinY() + "," + double_.getMinX();
                        arrayList.add(string6);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("[ERROR] Input parameters were not valid latitudes and longitudes");
                }
            }
        } else if (string2 != null && string2.equals("pointradius")) {
            string = httpServletRequest.getParameter("radius");
            String string7 = httpServletRequest.getParameter("lat");
            String string8 = httpServletRequest.getParameter("lon");
            if (string != null && string7 != null && string8 != null) {
                DirectPosition2D directPosition2D = null;
                try {
                    directPosition2D = new DirectPosition2D(Double.parseDouble(string8), Double.parseDouble(string7));
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("{ERROR] Input parameters were not valid latitudes and longitudes");
                }
                double d = Double.parseDouble(string);
                String string9 = "";
                for (int i = 0; i < 360; i += 10) {
                    DirectPosition2D directPosition2D2 = DistanceUtils.getPointOnGreatCircle((double)directPosition2D.y, (double)directPosition2D.x, (double)d, (double)i);
                    string9 = string9 + directPosition2D2.y + "," + directPosition2D2.x + ",";
                }
                DirectPosition2D directPosition2D3 = DistanceUtils.getPointOnGreatCircle((double)directPosition2D.y, (double)directPosition2D.x, (double)d, (double)0.0);
                string9 = string9 + directPosition2D3.y + "," + directPosition2D3.x + ",";
                arrayList.add(string9.substring(0, string9.length() - 1));
                l = System.currentTimeMillis();
                list = this.tree.queryByPointRadius(directPosition2D, d);
                l2 = System.currentTimeMillis();
            }
        }
        long l3 = l2 - l;
        printWriter.write(this.buildXML(list, arrayList, l3));
        printWriter.close();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        String string = httpServletRequest.getParameter("filename");
        if (string != null) {
            HashMap hashMap = GeoRSSData.loadFromFile((String)(this.georssStoragePath + string));
            String string2 = "";
            if (hashMap.get("title") != null && !((String)hashMap.get("title")).equals("null")) {
                string2 = string2 + "<b>Title:&nbsp;</b>" + (String)hashMap.get("title") + "<br />";
            }
            if (hashMap.get("link") != null && !((String)hashMap.get("link")).equals("null")) {
                string2 = string2 + "<b>Link:&nbsp;</b><a target='_blank' href='" + (String)hashMap.get("link") + "'" + ">" + (String)hashMap.get("link") + "</a><br />";
            }
            if (hashMap.get("author") != null && !((String)hashMap.get("author")).equals("null")) {
                string2 = string2 + "<b>Author:&nbsp;</b>" + (String)hashMap.get("author") + "<br />";
            }
            if (hashMap.get("pubDate") != null && !((String)hashMap.get("pubDate")).equals("null")) {
                string2 = string2 + "<b>Pub Date:&nbsp;</b>" + (String)hashMap.get("pubDate") + "<br />";
            }
            if (hashMap.get("description") != null && !((String)hashMap.get("description")).equals("null")) {
                string2 = string2 + "<b>Description:&nbsp;</b>" + (String)hashMap.get("description") + "<br />";
            }
            string2 = string2 + "<b>Lat:&nbsp;</b>" + (String)hashMap.get("lat") + "<br />";
            string2 = string2 + "<b>Lon:&nbsp;</b>" + (String)hashMap.get("lon") + "<br />";
            printWriter.write(string2);
        }
        printWriter.close();
    }

    private String buildXML(List<QuadTreeData> list, List<String> list2, long l) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            Object object;
            Object object2;
            Object object3;
            Object object5;
            Element element;
            Object object622;
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element2 = document.createElement("root");
            document.appendChild(element2);
            for (Object object622 : list) {
                element = document.createElement("item");
                object5 = document.createElement("id");
                Text object42 = document.createTextNode(object622.getFileName());
                object5.appendChild(object42);
                element.appendChild((Node)object5);
                object3 = document.createElement("lat");
                object2 = document.createTextNode(Double.toString(object622.getLatLon().y));
                object3.appendChild((Node)object2);
                element.appendChild((Node)object3);
                object = document.createElement("lon");
                Text text = document.createTextNode(Double.toString(object622.getLatLon().x));
                object.appendChild(text);
                element.appendChild((Node)object);
                element2.appendChild(element);
            }
            Element element3 = document.createElement("time");
            object622 = document.createTextNode(Long.toString(l));
            element3.appendChild((Node)object622);
            element2.appendChild(element3);
            if (this.timeToLoad != null) {
                element = document.createElement("indexLoadTime");
                object5 = document.createTextNode(this.timeToLoad);
                element.appendChild((Node)object5);
                element2.appendChild(element);
                this.timeToLoad = null;
            }
            element = document.createElement("query");
            element2.appendChild(element);
            for (String string : list2) {
                object3 = document.createElement("region");
                object2 = document.createTextNode(string);
                object3.appendChild((Node)object2);
                element.appendChild((Node)object3);
            }
            try {
                object5 = TransformerFactory.newInstance();
                Transformer transformer = ((TransformerFactory)object5).newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("indent", "yes");
                object3 = new StringWriter();
                object2 = new StreamResult((Writer)object3);
                object = new DOMSource(document);
                transformer.transform((Source)object, (Result)object2);
                return ((StringWriter)object3).toString();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
            }
            catch (TransformerException transformerException) {
                transformerException.printStackTrace();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return null;
    }

    private static String cleanStr(String string) {
        String string2 = string;
        return string2.replaceAll("[^a-zA-Z0-9]", "");
    }
}

