/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.index.tree;

import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.rss.Item;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.sis.geometry.DirectPosition2D;
import org.apache.sis.index.tree.QuadTreeData;

public class GeoRSSData
implements QuadTreeData {
    private String filename;
    private DirectPosition2D latLon;

    public GeoRSSData(String string, DirectPosition2D directPosition2D) {
        this.filename = string;
        this.latLon = directPosition2D;
    }

    public double getX() {
        return this.latLon.x + 180.0;
    }

    public double getY() {
        return this.latLon.y + 90.0;
    }

    public DirectPosition2D getLatLon() {
        return this.latLon;
    }

    public String getFileName() {
        return this.filename;
    }

    public void saveToFile(Item item, GeoRSSModule geoRSSModule, String string) {
        if (!new File(string).exists()) {
            new File(string).mkdirs();
        }
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string + this.filename));
            if (item.getTitle() != null) {
                bufferedWriter.write("title;" + item.getTitle().replace('\n', ' '));
                bufferedWriter.newLine();
            }
            if (item.getLink() != null) {
                bufferedWriter.write("link;" + item.getLink().replace('\n', ' '));
                bufferedWriter.newLine();
            }
            if (item.getSource() != null) {
                bufferedWriter.write("source;" + item.getSource().getValue().replace('\n', ' '));
                bufferedWriter.newLine();
            }
            if (item.getAuthor() != null) {
                bufferedWriter.write("author;" + item.getAuthor().replace('\n', ' '));
                bufferedWriter.newLine();
            }
            if (item.getDescription() != null) {
                bufferedWriter.write("description;" + item.getDescription().getValue().replace('\n', ' '));
                bufferedWriter.newLine();
            }
            bufferedWriter.write("pubDate;" + item.getPubDate().toString());
            bufferedWriter.newLine();
            bufferedWriter.write("lat;" + geoRSSModule.getPosition().getLatitude());
            bufferedWriter.newLine();
            bufferedWriter.write("lon;" + geoRSSModule.getPosition().getLongitude());
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static HashMap<String, String> loadFromFile(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf(59);
                if (n == -1) continue;
                hashMap.put(string2.substring(0, n), string2.substring(n + 1, string2.length()));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    }
}

