/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.openoffice;

import java.util.Arrays;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.openoffice.CacheKey;
import org.apache.sis.openoffice.ReferencingFunctions;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.collection.Cache;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class Transformer {
    private double westBoundLongitude;
    private double eastBoundLongitude;
    private double southBoundLatitude;
    private double northBoundLatitude;
    private CoordinateOperation operation;
    TransformException warning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Transformer(ReferencingFunctions caller, CoordinateReferenceSystem sourceCRS, String targetCRS, double[][] points) throws FactoryException, DataStoreException {
        double[] dArray;
        boolean hasAreaOfInterest;
        GeographicCRS domainCRS = ReferencingUtilities.toNormalizedGeographicCRS((CoordinateReferenceSystem)sourceCRS, (boolean)false, (boolean)false);
        if (domainCRS != null) {
            MathTransform toDomainOfValidity = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)domainCRS, null).getMathTransform();
            int dimension = toDomainOfValidity.getSourceDimensions();
            double[] domainCoord = new double[toDomainOfValidity.getTargetDimensions()];
            if (domainCoord.length >= 2) {
                this.westBoundLongitude = Double.POSITIVE_INFINITY;
                this.southBoundLatitude = Double.POSITIVE_INFINITY;
                this.eastBoundLongitude = Double.NEGATIVE_INFINITY;
                this.northBoundLatitude = Double.NEGATIVE_INFINITY;
                if (points != null) {
                    for (double[] coord : points) {
                        if (coord == null || coord.length != dimension) continue;
                        try {
                            toDomainOfValidity.transform(coord, 0, domainCoord, 0, 1);
                        }
                        catch (TransformException e) {
                            if (this.warning != null) continue;
                            this.warning = e;
                            continue;
                        }
                        double x = domainCoord[0];
                        double y = domainCoord[1];
                        if (x < this.westBoundLongitude) {
                            this.westBoundLongitude = x;
                        }
                        if (x > this.eastBoundLongitude) {
                            this.eastBoundLongitude = x;
                        }
                        if (y < this.southBoundLatitude) {
                            this.southBoundLatitude = y;
                        }
                        if (!(y > this.northBoundLatitude)) continue;
                        this.northBoundLatitude = y;
                    }
                }
            }
        }
        if (hasAreaOfInterest = this.hasAreaOfInterest()) {
            double[] dArray2 = new double[4];
            dArray2[0] = this.westBoundLongitude;
            dArray2[1] = this.eastBoundLongitude;
            dArray2[2] = this.southBoundLatitude;
            dArray = dArray2;
            dArray2[3] = this.northBoundLatitude;
        } else {
            dArray = null;
        }
        CacheKey<CoordinateOperation> key = new CacheKey<CoordinateOperation>(CoordinateOperation.class, targetCRS, sourceCRS, dArray);
        this.operation = key.peek();
        if (this.operation == null) {
            Cache.Handler<CoordinateOperation> handler = key.lock();
            try {
                this.operation = (CoordinateOperation)handler.peek();
                if (this.operation == null) {
                    this.operation = CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)caller.getCRS(targetCRS), (GeographicBoundingBox)(hasAreaOfInterest ? this.getAreaOfInterest() : null));
                }
            }
            finally {
                handler.putAndUnlock((Object)this.operation);
            }
        }
    }

    final boolean hasAreaOfInterest() {
        return this.westBoundLongitude < this.eastBoundLongitude && this.southBoundLatitude < this.northBoundLatitude;
    }

    final GeographicBoundingBox getAreaOfInterest() {
        return new DefaultGeographicBoundingBox(this.westBoundLongitude, this.eastBoundLongitude, this.southBoundLatitude, this.northBoundLatitude);
    }

    final double getAccuracy() {
        return AbstractCoordinateOperation.castOrCopy((CoordinateOperation)this.operation).getLinearAccuracy();
    }

    final double[][] transform(double[][] points) {
        MathTransform mt = this.operation.getMathTransform();
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(mt.getSourceDimensions());
        GeneralDirectPosition targetPt = new GeneralDirectPosition(mt.getTargetDimensions());
        double[][] result = new double[points.length][];
        for (int j = 0; j < points.length; ++j) {
            double[] coords = points[j];
            if (coords == null) continue;
            int i = sourcePt.coordinates.length;
            while (--i >= 0) {
                sourcePt.coordinates[i] = i < coords.length ? coords[i] : 0.0;
            }
            try {
                result[j] = mt.transform((DirectPosition)sourcePt, (DirectPosition)targetPt).getCoordinate();
                continue;
            }
            catch (TransformException exception) {
                double[] pad = new double[mt.getTargetDimensions()];
                Arrays.fill(pad, Double.NaN);
                result[j] = pad;
                if (this.warning != null) continue;
                this.warning = exception;
            }
        }
        return result;
    }

    final double[][] transformEnvelope(double[][] points) throws TransformException {
        double[] min = new double[this.operation.getMathTransform().getSourceDimensions()];
        double[] max = new double[min.length];
        Arrays.fill(min, Double.POSITIVE_INFINITY);
        Arrays.fill(max, Double.NEGATIVE_INFINITY);
        for (double[] p : points) {
            if (p == null) continue;
            int i = Math.min(min.length, p.length);
            while (--i >= 0) {
                double v = p[i];
                if (v < min[i]) {
                    min[i] = v;
                }
                if (!(v > max[i])) continue;
                max[i] = v;
            }
        }
        GeneralEnvelope result = Envelopes.transform((CoordinateOperation)this.operation, (Envelope)new GeneralEnvelope(min, max));
        return new double[][]{result.getLowerCorner().getCoordinate(), result.getUpperCorner().getCoordinate()};
    }
}

