/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.openoffice;

import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.registry.XRegistryKey;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.openoffice.ReferencingFunctions;

public final class Registration {
    static final String LOGGER = "org.apache.sis.openoffice";

    private Registration() {
    }

    private static void fatalException(String method, String message, Throwable exception) {
        Logger logger = Logger.getLogger(LOGGER);
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceClassName(Registration.class.getName());
        record.setSourceMethodName(method);
        record.setLoggerName(LOGGER);
        record.setThrown(exception);
        logger.log(record);
    }

    private static void classpathException(String method, Throwable exception) {
        String lineSeparator = System.lineSeparator();
        StringBuilder message = new StringBuilder("Cannot find Apache SIS classes.").append(lineSeparator).append("Classpath = ").append(System.getProperty("java.class.path"));
        ClassLoader loader = ReferencingFunctions.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                message.append(lineSeparator).append("  + ").append(url);
            }
        }
        Registration.fatalException(method, message.toString(), exception);
    }

    public static XSingleComponentFactory __getComponentFactory(String implementation) {
        if (implementation.equals("org.apache.sis.openoffice.ReferencingFunctions")) {
            try {
                return Factory.createComponentFactory(ReferencingFunctions.class, (String[])new String[]{"org.apache.sis.openoffice.Referencing"});
            }
            catch (LinkageError e) {
                Registration.classpathException("__getComponentFactory", e);
                throw e;
            }
        }
        return null;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey registry) {
        try {
            return Factory.writeRegistryServiceInfo((String)"org.apache.sis.openoffice.ReferencingFunctions", (String[])new String[]{"org.apache.sis.openoffice.Referencing"}, (XRegistryKey)registry);
        }
        catch (LinkageError e) {
            Registration.classpathException("__writeRegistryServiceInfo", e);
            return false;
        }
    }
}

