/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.openoffice;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.XComponentContext;
import java.util.Locale;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.openoffice.AnglePattern;
import org.apache.sis.openoffice.CacheKey;
import org.apache.sis.openoffice.CalcAddins;
import org.apache.sis.openoffice.Transformer;
import org.apache.sis.openoffice.XReferencing;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.base.CodeType;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Locales;
import org.apache.sis.util.collection.Cache;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public class ReferencingFunctions
extends CalcAddins
implements XReferencing {
    static final String SERVICE_NAME = "org.apache.sis.openoffice.Referencing";
    static final String IMPLEMENTATION_NAME = "org.apache.sis.openoffice.ReferencingFunctions";

    public ReferencingFunctions(XComponentContext context) {
        super(context);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    public String getImplementationName() {
        return IMPLEMENTATION_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IdentifiedObject getIdentifiedObject(String codeOrPath, CodeType type) throws FactoryException, DataStoreException {
        IdentifiedObject object;
        block18: {
            CacheKey<IdentifiedObject> key = new CacheKey<IdentifiedObject>(IdentifiedObject.class, codeOrPath, null, null);
            object = key.peek();
            if (object == null) {
                Cache.Handler<IdentifiedObject> handler = key.lock();
                try {
                    Metadata metadata;
                    object = (IdentifiedObject)handler.peek();
                    if (object != null) break block18;
                    if (type == null) {
                        type = CodeType.guess((String)codeOrPath);
                    }
                    if (type.equals((Object)CodeType.URN)) {
                        object = CRS.getAuthorityFactory(null).createObject(codeOrPath);
                        break block18;
                    }
                    if (type.isCRS) {
                        object = CRS.forCode((String)codeOrPath);
                        break block18;
                    }
                    try (DataStore store = DataStores.open((Object)codeOrPath);){
                        metadata = store.getMetadata();
                    }
                    if (metadata != null) {
                        for (ReferenceSystem rs : metadata.getReferenceSystemInfo()) {
                            if (rs instanceof CoordinateReferenceSystem) {
                                ReferenceSystem referenceSystem = rs;
                                return referenceSystem;
                            }
                            if (object != null) continue;
                            object = rs;
                        }
                    }
                    if (object == null) {
                        throw new FactoryException(Errors.getResources((Locale)this.getJavaLocale()).getString((short)157));
                    }
                }
                finally {
                    handler.putAndUnlock((Object)object);
                }
            }
        }
        return object;
    }

    @Override
    public String getName(String codeOrPath) {
        InternationalString name;
        try {
            CodeType type = CodeType.guess((String)codeOrPath);
            IdentifiedObject object = type.isCRS ? new CacheKey<IdentifiedObject>(IdentifiedObject.class, codeOrPath, null, null).peek() : this.getIdentifiedObject(codeOrPath, type);
            if (object != null) {
                return object.getName().getCode();
            }
            name = CRS.getAuthorityFactory(null).getDescriptionText(codeOrPath);
        }
        catch (Exception exception) {
            return this.getLocalizedMessage(exception);
        }
        return name != null ? name.toString(this.getJavaLocale()) : this.noResultString();
    }

    @Override
    public String getScope(String codeOrPath) {
        try {
            IdentifiedObject object = this.getIdentifiedObject(codeOrPath, null);
            for (DefaultObjectDomain domain : Legacy.getDomains((IdentifiedObject)object)) {
                InternationalString scope = domain.getScope();
                if (scope == null) continue;
                return scope.toString(this.getJavaLocale());
            }
        }
        catch (Exception exception) {
            return this.getLocalizedMessage(exception);
        }
        return this.noResultString();
    }

    @Override
    public String getDomainOfValidity(String codeOrPath) {
        try {
            IdentifiedObject object = this.getIdentifiedObject(codeOrPath, null);
            for (DefaultObjectDomain domain : Legacy.getDomains((IdentifiedObject)object)) {
                InternationalString description;
                Extent extent = domain.getDomainOfValidity();
                if (extent == null || (description = extent.getDescription()) == null) continue;
                return description.toString(this.getJavaLocale());
            }
        }
        catch (Exception exception) {
            return this.getLocalizedMessage(exception);
        }
        return this.noResultString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getGeographicArea(String codeOrPath) {
        GeographicBoundingBox area;
        block8: {
            CacheKey<GeographicBoundingBox> key = new CacheKey<GeographicBoundingBox>(GeographicBoundingBox.class, codeOrPath, null, null);
            area = key.peek();
            if (area == null) {
                Cache.Handler<GeographicBoundingBox> handler = key.lock();
                try {
                    area = (GeographicBoundingBox)handler.peek();
                    if (area != null) break block8;
                    try {
                        IdentifiedObject object = this.getIdentifiedObject(codeOrPath, null);
                        for (DefaultObjectDomain domain : Legacy.getDomains((IdentifiedObject)object)) {
                            area = Extents.getGeographicBoundingBox((Extent)domain.getDomainOfValidity());
                            if (area == null) continue;
                        }
                    }
                    catch (Exception exception) {
                        this.reportException("getGeographicArea", exception);
                    }
                }
                finally {
                    handler.putAndUnlock((Object)area);
                }
            }
        }
        if (area == null) {
            return new double[0][];
        }
        return new double[][]{{area.getNorthBoundLatitude(), area.getWestBoundLongitude()}, {area.getSouthBoundLatitude(), area.getEastBoundLongitude()}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAxis(String codeOrPath, int dimension) {
        Object name;
        block18: {
            CacheKey<String> key = new CacheKey<String>(String.class, codeOrPath, dimension, null);
            name = key.peek();
            if (name == null) {
                Cache.Handler<String> handler = key.lock();
                try {
                    CoordinateSystemAxis axis;
                    IdentifiedObject object;
                    name = (String)handler.peek();
                    if (name != null) break block18;
                    try {
                        object = this.getIdentifiedObject(codeOrPath, null);
                    }
                    catch (Exception exception) {
                        String string = this.getLocalizedMessage(exception);
                        handler.putAndUnlock(name);
                        return string;
                    }
                    CoordinateSystem cs = null;
                    if (object instanceof CoordinateSystemAxis) {
                        axis = (CoordinateSystemAxis)object;
                    } else {
                        if (object instanceof CoordinateReferenceSystem) {
                            cs = ((CoordinateReferenceSystem)object).getCoordinateSystem();
                        } else if (object instanceof CoordinateSystem) {
                            cs = (CoordinateSystem)object;
                        } else {
                            Class actual = object instanceof AbstractIdentifiedObject ? ((AbstractIdentifiedObject)object).getInterface() : Classes.getClass((Object)object);
                            String string = Errors.getResources((Locale)this.getJavaLocale()).getString((short)143, (Object)codeOrPath, CoordinateReferenceSystem.class, (Object)actual);
                            return string;
                        }
                        if (dimension >= 1 && dimension <= cs.getDimension()) {
                            axis = cs.getAxis(dimension - 1);
                        } else {
                            String actual = Errors.getResources((Locale)this.getJavaLocale()).getString((short)71, (Object)dimension);
                            return actual;
                        }
                    }
                    String unit = axis.getUnit().toString();
                    name = Transliterator.DEFAULT.toShortAxisName(cs, axis.getDirection(), axis.getName().getCode());
                    if (unit != null && !unit.isEmpty()) {
                        name = (String)name + " (" + unit + ")";
                    }
                }
                finally {
                    handler.putAndUnlock(name);
                }
            }
        }
        return name;
    }

    final CoordinateReferenceSystem getCRS(String codeOrPath) throws FactoryException, DataStoreException {
        IdentifiedObject object = this.getIdentifiedObject(codeOrPath, null);
        if (object == null || object instanceof CoordinateReferenceSystem) {
            return (CoordinateReferenceSystem)object;
        }
        throw new FactoryException(Errors.getResources((Locale)this.getJavaLocale()).getString((short)143, (Object)codeOrPath, CoordinateReferenceSystem.class, (Object)Classes.getClass((Object)object)));
    }

    @Override
    public double getAccuracy(String sourceCRS, String targetCRS, Object areaOfInterest) throws IllegalArgumentException {
        Object coordinates;
        if (AnyConverter.isVoid((Object)areaOfInterest)) {
            coordinates = null;
        } else if (areaOfInterest instanceof double[][]) {
            coordinates = (double[][])areaOfInterest;
        } else if (areaOfInterest instanceof Object[][]) {
            Object[][] values = (Object[][])areaOfInterest;
            coordinates = new double[values.length][];
            for (int j = 0; j < values.length; ++j) {
                Object[] row = values[j];
                double[] coord = new double[row.length];
                for (int i = 0; i < row.length; ++i) {
                    coord[i] = AnyConverter.toDouble((Object)row[i]);
                }
                coordinates[j] = coord;
            }
        } else {
            throw new IllegalArgumentException();
        }
        try {
            return new Transformer(this, this.getCRS(sourceCRS), targetCRS, (double[][])coordinates).getAccuracy();
        }
        catch (Exception exception) {
            this.reportException("getAccuracy", exception);
            return Double.NaN;
        }
    }

    @Override
    public double[][] transformPoints(String sourceCRS, String targetCRS, double[][] points) {
        Exception warning;
        Object result;
        if (points == null || points.length == 0) {
            return new double[0][];
        }
        try {
            Transformer tr = new Transformer(this, this.getCRS(sourceCRS), targetCRS, points);
            result = tr.transform(points);
            warning = tr.warning;
        }
        catch (Exception exception) {
            result = new double[][]{};
            warning = exception;
        }
        if (warning != null) {
            this.reportException("transformPoints", warning);
        }
        return result;
    }

    @Override
    public double[][] transformEnvelope(String sourceCRS, String targetCRS, double[][] envelope) {
        if (envelope != null && envelope.length != 0) {
            try {
                return new Transformer(this, this.getCRS(sourceCRS), targetCRS, envelope).transformEnvelope(envelope);
            }
            catch (Exception exception) {
                this.reportException("transformEnvelope", exception);
            }
        }
        return new double[0][];
    }

    @Override
    public double[][] parseAngle(String[][] text, Object pattern, Object locale) throws IllegalArgumentException {
        AnglePattern p = new AnglePattern(pattern);
        double[][] result = p.parse(text, AnyConverter.isVoid((Object)locale) ? this.getJavaLocale() : Locales.parse((String)AnyConverter.toString((Object)locale)));
        if (p.warning != null) {
            this.reportException("parseAngle", p.warning);
        }
        return result;
    }

    @Override
    public String[][] formatAngle(double[][] value, Object pattern, Object locale) throws IllegalArgumentException {
        return new AnglePattern(pattern).format(value, AnyConverter.isVoid((Object)locale) ? this.getJavaLocale() : Locales.parse((String)AnyConverter.toString((Object)locale)));
    }
}

