/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.openoffice;

import com.sun.star.lang.Locale;
import com.sun.star.lang.XLocalizable;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XServiceName;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.uno.XComponentContext;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Vocabulary;

public abstract class CalcAddins
extends WeakBase
implements XServiceName,
XServiceInfo,
XLocalizable {
    protected final XComponentContext context;
    private Locale locale;
    private transient java.util.Locale javaLocale;
    private transient Logger logger;

    protected CalcAddins(XComponentContext context) {
        this.context = context;
    }

    public abstract String getServiceName();

    public final String[] getSupportedServiceNames() {
        return new String[]{this.getServiceName()};
    }

    public final boolean supportsService(String name) {
        return name.equals(this.getServiceName());
    }

    public final synchronized void setLocale(Locale locale) {
        this.locale = locale;
        this.javaLocale = null;
    }

    public final synchronized Locale getLocale() {
        if (this.locale == null) {
            this.locale = new Locale();
        }
        return this.locale;
    }

    protected final synchronized java.util.Locale getJavaLocale() {
        if (this.javaLocale == null) {
            if (this.locale != null) {
                String variant;
                String country;
                String language = this.locale.Language;
                if (language == null) {
                    language = "";
                }
                if ((country = this.locale.Country) == null) {
                    country = "";
                }
                if ((variant = this.locale.Variant) == null) {
                    variant = "";
                }
                this.javaLocale = new java.util.Locale(language, country, variant);
            } else {
                this.javaLocale = java.util.Locale.getDefault();
            }
        }
        return this.javaLocale;
    }

    final String noResultString() {
        return Vocabulary.getResources((java.util.Locale)this.getJavaLocale()).getString((short)207);
    }

    static int getMinimalLength(Object[] array1, Object[] array2) {
        if (array1 == null || array2 == null) {
            return 0;
        }
        if (array1.length == 1) {
            return array2.length;
        }
        if (array2.length == 1) {
            return array1.length;
        }
        return Math.min(array1.length, array2.length);
    }

    protected final String getLocalizedMessage(Throwable exception) {
        String message = Exceptions.getLocalizedMessage((Throwable)exception, (java.util.Locale)this.getJavaLocale());
        if (message != null) {
            return message;
        }
        return Classes.getShortClassName((Object)exception);
    }

    final void reportException(String method, Exception exception) {
        Logger logger = this.getLogger();
        LogRecord record = new LogRecord(Level.WARNING, this.getLocalizedMessage(exception));
        record.setLoggerName(logger.getName());
        record.setSourceClassName(((Object)((Object)this)).getClass().getName());
        record.setSourceMethodName(method);
        record.setThrown(exception);
        logger.log(record);
    }

    protected final synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("org.apache.sis.openoffice");
        }
        return this.logger;
    }
}

