/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.openoffice;

import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.util.collection.Cache;

final class CacheKey<T> {
    private static final Cache<CacheKey<?>, Object> cache = new Cache(32, 10L, true);
    private final Class<T> type;
    private String key;
    private Object ext;
    private final double[] area;

    CacheKey(Class<T> type, String key, Object ext, double[] area) {
        this.type = type;
        this.key = key.trim();
        this.ext = ext;
        this.area = area;
    }

    final T peek() {
        return this.type.cast(cache.peek((Object)this));
    }

    final Cache.Handler<T> lock() {
        this.key = this.key.intern();
        if (this.ext instanceof String) {
            this.ext = ((String)this.ext).intern();
        }
        return cache.lock((Object)this);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.key, this.ext) + Arrays.hashCode(this.area);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CacheKey) {
            CacheKey that = (CacheKey)obj;
            return this.type.equals(that.type) && this.key.equals(that.key) && Objects.equals(this.ext, that.ext) && Arrays.equals(this.area, that.area);
        }
        return false;
    }
}

