/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.openoffice;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import java.text.ParseException;
import java.util.Locale;
import org.apache.sis.measure.Angle;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.openoffice.CacheKey;
import org.apache.sis.util.collection.Cache;

final class AnglePattern {
    private static final byte LATITUDE = 1;
    private static final byte LONGITUDE = 2;
    private String pattern;
    private byte type;
    ParseException warning;

    AnglePattern(Object patternOrVoid) throws IllegalArgumentException {
        if (AnyConverter.isVoid((Object)patternOrVoid)) {
            this.pattern = "D\u00b0MM'SS.s\"";
        } else {
            this.pattern = AnyConverter.toString((Object)patternOrVoid);
            int lc = this.pattern.length() - 1;
            if (lc > 0) {
                char c = this.pattern.charAt(lc);
                switch (c) {
                    case 'N': 
                    case 'S': 
                    case 'n': 
                    case 's': {
                        this.type = 1;
                        break;
                    }
                    case 'E': 
                    case 'W': 
                    case 'e': 
                    case 'w': {
                        this.type = (byte)2;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.pattern = this.pattern.substring(0, lc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AngleFormat getAngleFormat(Locale locale) {
        CacheKey<AngleFormat> key = new CacheKey<AngleFormat>(AngleFormat.class, this.pattern, locale, null);
        AngleFormat format = key.peek();
        if (format == null) {
            Cache.Handler<AngleFormat> handler = key.lock();
            try {
                format = (AngleFormat)handler.peek();
                if (format == null) {
                    format = new AngleFormat(this.pattern, locale);
                }
            }
            finally {
                handler.putAndUnlock((Object)format);
            }
        }
        return format;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double[][] parse(String[][] text, Locale locale) {
        AngleFormat format = this.getAngleFormat(locale);
        double[][] value = new double[text.length][];
        AngleFormat angleFormat = format;
        synchronized (angleFormat) {
            for (int j = 0; j < text.length; ++j) {
                String[] input = text[j];
                if (input == null) continue;
                double[] result = new double[input.length];
                for (int i = 0; i < input.length; ++i) {
                    try {
                        result[i] = format.parse(input[i]).degrees();
                        continue;
                    }
                    catch (ParseException e) {
                        result[i] = Double.NaN;
                        if (this.warning != null) continue;
                        this.warning = e;
                    }
                }
                value[j] = result;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[][] format(double[][] value, Locale locale) {
        AngleFormat format = this.getAngleFormat(locale);
        String[][] text = new String[value.length][];
        AngleFormat angleFormat = format;
        synchronized (angleFormat) {
            for (int j = 0; j < value.length; ++j) {
                double[] input = value[j];
                if (input == null) continue;
                String[] result = new String[input.length];
                for (int i = 0; i < input.length; ++i) {
                    Angle angle;
                    double v = input[i];
                    switch (this.type) {
                        default: {
                            angle = new Angle(v);
                            break;
                        }
                        case 1: {
                            angle = new Latitude(v);
                            break;
                        }
                        case 2: {
                            angle = new Longitude(v);
                        }
                    }
                    result[i] = format.format((Object)angle);
                }
                text[j] = result;
            }
        }
        return text;
    }
}

