/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.io.TableAppender;
import org.apache.sis.util.resources.Vocabulary;

final class HelpCommand
extends CommandRunner {
    private static final String[] COMMANDS = new String[]{"help", "about", "mime-type", "metadata", "crs", "identifier", "transform"};

    HelpCommand(CommandRunner commandRunner) {
        super(commandRunner);
    }

    HelpCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, EnumSet.of(Option.LOCALE, Option.ENCODING, Option.HELP, Option.DEBUG));
    }

    @Override
    public int run() throws IOException {
        if (this.hasUnexpectedFileCount(0, 0)) {
            return 3;
        }
        this.help(true, COMMANDS, EnumSet.allOf(Option.class));
        return 0;
    }

    void help(boolean bl, String[] stringArray, EnumSet<Option> enumSet) throws IOException {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.apache.sis.console.Commands", this.locale);
        ResourceBundle resourceBundle2 = ResourceBundle.getBundle("org.apache.sis.console.Options", this.locale);
        Vocabulary vocabulary = Vocabulary.getResources((Locale)this.locale);
        if (bl) {
            this.out.print("Apache SIS, ");
            this.out.println(resourceBundle.getString("SIS"));
            this.out.println(resourceBundle.getString("Usage"));
            this.out.println();
            this.out.print(vocabulary.getString((short)16));
            this.out.println(':');
        }
        TableAppender tableAppender = new TableAppender((Appendable)this.out, "  ");
        for (String string : stringArray) {
            if (bl) {
                tableAppender.append((CharSequence)"  ");
            }
            tableAppender.append((CharSequence)string);
            if (!bl) {
                tableAppender.append(':');
            }
            tableAppender.nextColumn();
            tableAppender.append((CharSequence)resourceBundle.getString(string));
            tableAppender.nextLine();
        }
        tableAppender.flush();
        this.out.println();
        this.out.print(vocabulary.getString((short)83));
        this.out.println(':');
        for (Option option : enumSet) {
            String string = option.label();
            tableAppender.append((CharSequence)"  ").append((CharSequence)"--").append((CharSequence)string);
            tableAppender.nextColumn();
            tableAppender.append((CharSequence)resourceBundle2.getString(string));
            tableAppender.nextLine();
        }
        tableAppender.flush();
    }
}

