/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.EnumSet;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.OutputFormat;
import org.apache.sis.internal.storage.CodeType;
import org.apache.sis.internal.storage.gpx.Store;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.referencing.CRS;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTableFormat;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.MarshallerPool;
import org.opengis.metadata.Metadata;
import org.opengis.util.FactoryException;

abstract class FormattedOutputCommand
extends CommandRunner {
    private final OutputFormat outputFormat;
    Convention convention;
    private Version version;
    private final DataStoreProvider provider;
    boolean hasUnexpectedFileCount;

    FormattedOutputCommand(int n, String[] stringArray, EnumSet<Option> enumSet, OutputFormat ... outputFormatArray) throws InvalidOptionException {
        super(n, stringArray, enumSet);
        boolean bl = true;
        String string = (String)this.options.get((Object)Option.FORMAT);
        if (string == null) {
            this.outputFormat = outputFormatArray[0];
            this.convention = Convention.WKT2_SIMPLIFIED;
        } else if (string.equalsIgnoreCase("WKT1")) {
            this.outputFormat = OutputFormat.WKT;
            this.convention = Convention.WKT1;
        } else if (string.equalsIgnoreCase("WKT2")) {
            this.outputFormat = OutputFormat.WKT;
            this.convention = Convention.WKT2;
        } else {
            int n2 = string.indexOf(45);
            String string2 = string;
            if (n2 > 0) {
                string2 = string.substring(0, n2);
                this.version = new Version(string.substring(n2 + 1).trim());
            }
            string2 = string2.toUpperCase(Locale.US);
            try {
                this.outputFormat = OutputFormat.valueOf(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidOptionException(Errors.format((short)56, (Object)"format", (Object)string), illegalArgumentException, "format");
            }
        }
        if (!ArraysExt.contains((Object[])outputFormatArray, (Object)((Object)this.outputFormat))) {
            throw new InvalidOptionException(Errors.format((short)62, (Object)this.commandName, (Object)((Object)this.outputFormat)), "format");
        }
        this.provider = this.outputFormat.provider();
        switch (this.outputFormat) {
            case WKT: {
                if (this.convention != null) break;
                if (this.version == null || this.version.equals((Object)Version.valueOf((int[])new int[]{2}))) {
                    this.convention = Convention.WKT2;
                    break;
                }
                this.convention = Convention.WKT1;
                bl = this.version.equals((Object)Version.valueOf((int[])new int[]{1}));
                break;
            }
            default: {
                if (this.version == null || !(bl = this.provider != null)) break;
                Range range = this.provider.getSupportedVersions();
                boolean bl2 = bl = range != null && range.contains((Comparable)this.version);
            }
        }
        if (!bl) {
            throw new InvalidOptionException(Errors.format((short)159, (Object)this.outputFormat.name(), (Object)this.version), "format");
        }
    }

    final Object readMetadataOrCRS() throws DataStoreException, FactoryException {
        if (this.useStandardInput()) {
            try (DataStore dataStore = DataStores.open((Object)System.in);){
                Metadata metadata = dataStore.getMetadata();
                return metadata;
            }
        }
        if (this.hasUnexpectedFileCount(1, 1)) {
            this.hasUnexpectedFileCount = true;
            return null;
        }
        String string = (String)this.files.get(0);
        if (CodeType.guess((String)string).isCRS) {
            return CRS.forCode((String)string);
        }
        try (DataStore dataStore = DataStores.open((Object)string);){
            Metadata metadata = dataStore.getMetadata();
            return metadata;
        }
    }

    /*
     * Unable to fully structure code
     */
    final void format(Object var1_1) throws DataStoreException, JAXBException, IOException {
        switch (1.$SwitchMap$org$apache$sis$console$OutputFormat[this.outputFormat.ordinal()]) {
            case 2: {
                var2_2 = MetadataStandard.ISO_19115.asTreeTable(var1_1, var1_1 instanceof Metadata != false ? Metadata.class : null, ValueExistencePolicy.COMPACT);
                var3_6 = new TreeTableFormat(this.locale, this.timezone);
                var3_6.setColumns(new TableColumn[]{TableColumn.NAME, TableColumn.VALUE});
                var3_6.format(var2_2, (Appendable)this.out);
                break;
            }
            case 1: {
                var2_3 = new WKTFormat(this.locale, this.timezone);
                if (this.convention != null) {
                    var2_3.setConvention(this.convention);
                }
                if (this.colors) {
                    var2_3.setColors(Colors.DEFAULT);
                }
                var2_3.format(var1_1, (Appendable)this.out);
                this.out.println();
                break;
            }
            case 3: {
                var2_4 = new MarshallerPool(null);
                var3_7 = var2_4.acquireMarshaller();
                var3_7.setProperty("org.apache.sis.xml.locale", (Object)this.locale);
                var3_7.setProperty("org.apache.sis.xml.timezone", (Object)this.timezone);
                if (this.isConsole()) {
                    var3_7.marshal(var1_1, (Writer)this.out);
                    break;
                }
                this.out.flush();
                var3_7.setProperty("jaxb.encoding", (Object)this.encoding.name());
                var3_7.marshal(var1_1, (OutputStream)System.out);
                System.out.flush();
                break;
            }
            default: {
                var2_5 = new StorageConnector((Object)this.out);
                var2_5.setOption(OptionKey.TIMEZONE, (Object)this.timezone);
                var2_5.setOption(OptionKey.LOCALE, (Object)this.locale);
                var2_5.setOption(OptionKey.ENCODING, (Object)this.encoding);
                var3_8 = this.provider.open(var2_5);
                var4_9 = null;
                var5_10 = (Store)var3_8;
                if (this.version != null) {
                    var5_10.setVersion(this.version);
                }
                var5_10.write(var1_1 instanceof Metadata != false ? (Metadata)var1_1 : null, null);
                if (var3_8 == null) break;
                if (var4_9 == null) ** GOTO lbl50
                try {
                    var3_8.close();
                }
                catch (Throwable var5_11) {
                    var4_9.addSuppressed(var5_11);
                }
                break;
lbl50:
                // 1 sources

                var3_8.close();
                break;
                catch (Throwable var5_12) {
                    try {
                        var4_9 = var5_12;
                        throw var5_12;
                    }
                    catch (Throwable var6_13) {
                        if (var3_8 != null) {
                            if (var4_9 != null) {
                                try {
                                    var3_8.close();
                                }
                                catch (Throwable var7_14) {
                                    var4_9.addSuppressed(var7_14);
                                }
                            } else {
                                var3_8.close();
                            }
                        }
                        throw var6_13;
                    }
                }
            }
        }
        this.out.flush();
    }

    private boolean isConsole() {
        if (this.outputBuffer != null) {
            return true;
        }
        Console console = System.console();
        return console != null && console.writer() == this.out;
    }
}

