/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import org.apache.sis.console.FormattedOutputCommand;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.MetadataCommand;
import org.apache.sis.console.OutputFormat;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

final class CRSCommand
extends FormattedOutputCommand {
    CRSCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, MetadataCommand.options(), OutputFormat.WKT, OutputFormat.XML);
    }

    @Override
    public int run() throws Exception {
        Object object = this.readMetadataOrCRS();
        if (this.hasUnexpectedFileCount) {
            return 3;
        }
        if (object != null) {
            if (object instanceof CoordinateReferenceSystem) {
                this.format(object);
            } else {
                for (ReferenceSystem referenceSystem : ((Metadata)object).getReferenceSystemInfo()) {
                    if (!(referenceSystem instanceof CoordinateReferenceSystem)) continue;
                    this.format(referenceSystem);
                    break;
                }
            }
        }
        return 0;
    }
}

