/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.IOException;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.sis.console.Command;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.internal.system.DataDirectory;
import org.apache.sis.internal.system.SupervisorMBean;
import org.apache.sis.internal.util.X364;
import org.apache.sis.setup.About;
import org.apache.sis.util.Version;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;

final class AboutCommand
extends CommandRunner {
    AboutCommand(int n, String ... stringArray) throws InvalidOptionException {
        super(n, stringArray, EnumSet.of(Option.LOCALE, new Option[]{Option.TIMEZONE, Option.ENCODING, Option.BRIEF, Option.VERBOSE, Option.HELP, Option.DEBUG}));
    }

    @Override
    public int run() throws Exception {
        String string;
        DataDirectory.quiet();
        boolean bl = this.options.containsKey((Object)Option.BRIEF);
        if (this.hasUnexpectedFileCount(0, bl ? 0 : 1)) {
            return 3;
        }
        String[] stringArray = null;
        if (bl && this.files.isEmpty()) {
            string = Vocabulary.getResources((Locale)this.locale).getString((short)114, (Object)"Apache SIS", (Object)Version.SIS);
        } else {
            EnumSet<About> enumSet = EnumSet.allOf(About.class);
            if (!this.options.containsKey((Object)Option.VERBOSE)) {
                enumSet.remove(About.LIBRARIES);
            }
            if (this.files.isEmpty()) {
                string = About.configuration(enumSet, (Locale)this.locale, (TimeZone)this.timezone).toString();
            } else {
                TreeTable treeTable;
                String string2 = (String)this.files.get(0);
                String string3 = AboutCommand.toRemoteURL(string2);
                long l = System.nanoTime();
                try {
                    JMXServiceURL jMXServiceURL = new JMXServiceURL(string3);
                    try (JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);){
                        MBeanServerConnection mBeanServerConnection = jMXConnector.getMBeanServerConnection();
                        SupervisorMBean supervisorMBean = JMX.newMBeanProxy(mBeanServerConnection, new ObjectName("org.apache.sis:type=Supervisor"), SupervisorMBean.class);
                        treeTable = supervisorMBean.configuration(enumSet, this.locale, this.timezone);
                        stringArray = supervisorMBean.warnings(this.locale);
                    }
                }
                catch (IOException iOException) {
                    this.error(Errors.format((short)6, (Object)string3), iOException);
                    return 100;
                }
                double d = (double)(System.nanoTime() - l) / 1.0E9;
                if (d >= 0.1) {
                    double d2 = d >= 10.0 ? 1.0 : (d >= 1.0 ? 10.0 : 100.0);
                    d = Math.rint(d * d2) / d2;
                }
                LogRecord logRecord = Messages.getResources((Locale)this.locale).getLogRecord(Level.INFO, (short)5, (Object)string2, (Object)new Date(), (Object)d);
                logRecord.setLoggerName("org.apache.sis.application");
                Logging.log(Command.class, (String)"main", (LogRecord)logRecord);
                treeTable.getRoot().setValue(TableColumn.NAME, (Object)Vocabulary.getResources((Locale)this.locale).getString((short)89));
                string = treeTable.toString();
            }
        }
        this.out.println(string);
        if (stringArray != null) {
            this.out.println();
            if (this.colors) {
                this.out.print(X364.BACKGROUND_RED.sequence());
                this.out.print(X364.BOLD.sequence());
                this.out.print('\u00a0');
            }
            Vocabulary.getResources((Locale)this.locale).appendLabel((short)117, (Appendable)this.out);
            if (this.colors) {
                this.out.print('\u00a0');
                this.out.println(X364.RESET.sequence());
                this.out.print(X364.FOREGROUND_RED.sequence());
            } else {
                this.out.println();
            }
            for (EnumSet<About> enumSet : stringArray) {
                this.out.println((String)((Object)enumSet));
            }
            if (this.colors) {
                this.out.print(X364.FOREGROUND_DEFAULT.sequence());
            }
        }
        this.out.flush();
        return 0;
    }

    static String toRemoteURL(String string) {
        StringBuilder stringBuilder = new StringBuilder(60).append("service:jmx:rmi:///jndi/rmi://").append(string, string.regionMatches(true, 0, "localhost", 0, 9) ? 9 : 0, string.length());
        if (string.lastIndexOf(58) < 0) {
            stringBuilder.append(':').append(1099);
        }
        return stringBuilder.append("/jmxrmi").toString();
    }
}

