/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.Option;
import org.apache.sis.console.SubCommand;
import org.apache.sis.internal.jdk7.StandardCharsets;
import org.apache.sis.test.DependsOnMethod;
import org.apache.sis.test.TestCase;
import org.apache.sis.test.TestUtilities;
import org.junit.Assert;
import org.junit.Test;

public strictfp final class SubCommandTest
extends TestCase {
    @Test
    public void testLocale() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "--locale", "ja");
        Assert.assertEquals((Object)Option.LOCALE, (Object)TestUtilities.getSingleton(dummy.options.keySet()));
        Assert.assertSame((String)"locale", (Object)Locale.JAPANESE, (Object)dummy.locale);
        Assert.assertTrue((String)"files.isEmpty()", (boolean)dummy.files.isEmpty());
    }

    @Test
    public void testTimeZone() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "--timezone", "JST");
        Assert.assertEquals((Object)Option.TIMEZONE, (Object)TestUtilities.getSingleton(dummy.options.keySet()));
        Assert.assertEquals((String)"timezone", (Object)TimeZone.getTimeZone("JST"), (Object)dummy.timezone);
        Assert.assertEquals((String)"rawoffset", (long)TimeUnit.HOURS.toMillis(9L), (long)dummy.timezone.getRawOffset());
        Assert.assertTrue((String)"files.isEmpty()", (boolean)dummy.files.isEmpty());
    }

    @Test
    public void testEncoding() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "--encoding", "UTF-16");
        Assert.assertEquals((Object)Option.ENCODING, (Object)TestUtilities.getSingleton(dummy.options.keySet()));
        Assert.assertEquals((String)"encoding", (Object)StandardCharsets.UTF_16, (Object)dummy.encoding);
        Assert.assertTrue((String)"files.isEmpty()", (boolean)dummy.files.isEmpty());
    }

    @Test
    @DependsOnMethod(value={"testLocale", "testTimeZone", "testEncoding"})
    public void testOptionMix() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "--brief", "--locale", "ja", "--verbose", "--timezone", "JST");
        Assert.assertEquals((String)"options", EnumSet.of(Option.BRIEF, Option.LOCALE, Option.VERBOSE, Option.TIMEZONE), dummy.options.keySet());
        Assert.assertSame((String)"locale", (Object)Locale.JAPANESE, (Object)dummy.locale);
        Assert.assertEquals((String)"timezone", (Object)TimeZone.getTimeZone("JST"), (Object)dummy.timezone);
        Assert.assertTrue((String)"files.isEmpty()", (boolean)dummy.files.isEmpty());
    }

    @Test
    @DependsOnMethod(value={"testLocale"})
    public void testMissingOptionValue() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "--brief");
        Assert.assertEquals((Object)Option.BRIEF, (Object)TestUtilities.getSingleton(dummy.options.keySet()));
        try {
            new Dummy(EnumSet.allOf(Option.class), "TEST", "--brief", "--locale");
            Assert.fail((String)"Expected InvalidOptionException");
        }
        catch (InvalidOptionException invalidOptionException) {
            String string = invalidOptionException.getMessage();
            Assert.assertTrue((boolean)string.contains("locale"));
        }
    }

    @Test
    public void testUnexpectedOption() throws InvalidOptionException {
        try {
            new Dummy(EnumSet.of(Option.HELP, Option.BRIEF), "TEST", "--brief", "--verbose", "--help");
            Assert.fail((String)"Expected InvalidOptionException");
        }
        catch (InvalidOptionException invalidOptionException) {
            String string = invalidOptionException.getMessage();
            Assert.assertTrue((boolean)string.contains("verbose"));
        }
    }

    @Test
    public void testHasContradictoryOptions() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "--brief", "--verbose");
        Assert.assertTrue((boolean)dummy.hasContradictoryOptions(new Option[]{Option.BRIEF, Option.VERBOSE}));
        String string = dummy.outputBuffer.toString();
        Assert.assertTrue((boolean)string.contains("brief"));
        Assert.assertTrue((boolean)string.contains("verbose"));
    }

    @Test
    public void testHasUnexpectedFileCount() throws InvalidOptionException {
        Dummy dummy = new Dummy(EnumSet.allOf(Option.class), "TEST", "MyFile.txt");
        Assert.assertFalse((boolean)dummy.hasUnexpectedFileCount(0, 1));
        Assert.assertEquals((Object)"", (Object)dummy.outputBuffer.toString());
        Assert.assertFalse((boolean)dummy.hasUnexpectedFileCount(1, 2));
        Assert.assertEquals((Object)"", (Object)dummy.outputBuffer.toString());
        Assert.assertTrue((boolean)dummy.hasUnexpectedFileCount(2, 3));
        String string = dummy.outputBuffer.toString();
        Assert.assertTrue((string.length() != 0 ? 1 : 0) != 0);
    }

    private strictfp static final class Dummy
    extends SubCommand {
        Dummy(EnumSet<Option> enumSet, String ... stringArray) throws InvalidOptionException {
            super(0, stringArray, enumSet);
        }

        public int run() {
            return 0;
        }
    }
}

