/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.net.URL;
import org.apache.sis.console.MetadataSC;
import org.apache.sis.console.SubCommandTest;
import org.apache.sis.test.DependsOn;
import org.apache.sis.test.DependsOnMethod;
import org.apache.sis.test.TestCase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@DependsOn(value={SubCommandTest.class})
public strictfp final class MetadataSCTest
extends TestCase {
    @Test
    @Ignore(value="Requires GeoAPI 3.1")
    public void testNetCDF() throws Exception {
        URL uRL = MetadataSCTest.class.getResource("NCEP-SST.nc");
        Assert.assertNotNull((String)"NCEP-SST.nc", (Object)uRL);
        MetadataSC metadataSC = new MetadataSC(false, 0, new String[]{"TEST", uRL.toString()});
        metadataSC.run();
        MetadataSCTest.verifyNetCDF("Metadata", metadataSC.outputBuffer.toString());
    }

    private static void verifyNetCDF(String string, String string2) {
        Assert.assertTrue((String)string, (boolean)string2.startsWith(string));
        Assert.assertTrue((String)"ISO 19115-2", (boolean)string2.contains("ISO 19115-2"));
        Assert.assertTrue((String)"Sea Surface Temperature Analysis Model", (boolean)string2.contains("Sea Surface Temperature Analysis Model"));
        Assert.assertTrue((String)"GCMD Science Keywords", (boolean)string2.contains("GCMD Science Keywords"));
        Assert.assertTrue((String)"NOAA/NWS/NCEP", (boolean)string2.contains("NOAA/NWS/NCEP"));
    }

    @Test
    @Ignore(value="Requires GeoAPI 3.1")
    @DependsOnMethod(value={"testNetCDF"})
    public void testFormatXML() throws Exception {
        URL uRL = MetadataSCTest.class.getResource("NCEP-SST.nc");
        MetadataSC metadataSC = new MetadataSC(false, 0, new String[]{"TEST", uRL.toString(), "--format", "XML"});
        metadataSC.run();
        MetadataSCTest.verifyNetCDF("<?xml", metadataSC.outputBuffer.toString());
    }
}

