/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import org.apache.sis.console.HelpSC;
import org.apache.sis.console.InvalidOptionException;
import org.apache.sis.console.SubCommandTest;
import org.apache.sis.test.DependsOn;
import org.apache.sis.test.TestCase;
import org.junit.Assert;
import org.junit.Test;

@DependsOn(value={SubCommandTest.class})
public strictfp final class HelpSCTest
extends TestCase {
    @Test
    public void testDefault() throws InvalidOptionException {
        HelpSC helpSC = new HelpSC(0, new String[]{"TEST"});
        helpSC.run();
        String string = helpSC.outputBuffer.toString();
        Assert.assertTrue((String)"Apache SIS", (boolean)string.startsWith("Apache SIS"));
        Assert.assertTrue((String)"--locale", (boolean)string.contains("--locale"));
        Assert.assertTrue((String)"--encoding", (boolean)string.contains("--encoding"));
        Assert.assertTrue((String)"--timezone", (boolean)string.contains("--timezone"));
        Assert.assertTrue((String)"--brief", (boolean)string.contains("--brief"));
        Assert.assertTrue((String)"--verbose", (boolean)string.contains("--verbose"));
        Assert.assertTrue((String)"--help", (boolean)string.contains("--help"));
    }

    @Test
    public void testHelp() throws InvalidOptionException {
        HelpSC helpSC = new HelpSC(0, new String[]{"TEST", "--help"});
        helpSC.help("help");
        String string = helpSC.outputBuffer.toString();
        Assert.assertTrue((String)"help", (boolean)string.startsWith("help"));
        Assert.assertTrue((String)"--locale", (boolean)string.contains("--locale"));
        Assert.assertTrue((String)"--encoding", (boolean)string.contains("--encoding"));
        Assert.assertFalse((String)"--timezone", (boolean)string.contains("--timezone"));
        Assert.assertFalse((String)"--brief", (boolean)string.contains("--brief"));
        Assert.assertFalse((String)"--verbose", (boolean)string.contains("--verbose"));
        Assert.assertTrue((String)"--help", (boolean)string.contains("--help"));
    }

    @Test
    public void testEnglishLocale() throws InvalidOptionException {
        HelpSC helpSC = new HelpSC(0, new String[]{"TEST", "--help", "--locale", "en"});
        helpSC.help("help");
        String string = helpSC.outputBuffer.toString();
        Assert.assertTrue((String)string, (boolean)string.contains("Show a help overview."));
        Assert.assertTrue((String)string, (boolean)string.contains("The locale to use"));
    }

    @Test
    public void testFrenchLocale() throws InvalidOptionException {
        HelpSC helpSC = new HelpSC(0, new String[]{"TEST", "--help", "--locale", "fr"});
        helpSC.help("help");
        String string = helpSC.outputBuffer.toString();
        Assert.assertTrue((String)string, (boolean)string.contains("Affiche un \u00e9cran d\u2019aide."));
        Assert.assertTrue((String)string, (boolean)string.contains("Les param\u00e8tres r\u00e9gionaux"));
    }
}

