/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import org.apache.sis.console.AboutSC;
import org.apache.sis.console.SubCommandTest;
import org.apache.sis.test.DependsOn;
import org.apache.sis.test.TestCase;
import org.apache.sis.test.TestUtilities;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Version;
import org.junit.Assert;
import org.junit.Test;

@DependsOn(value={SubCommandTest.class})
public strictfp final class AboutSCTest
extends TestCase {
    @Test
    public void testDefault() throws Exception {
        AboutSC aboutSC = new AboutSC(0, new String[]{"TEST"});
        aboutSC.run();
        AboutSCTest.verify(aboutSC.outputBuffer.toString());
    }

    private static void verify(String string) {
        String string2 = Version.SIS.toString();
        Assert.assertTrue((String)string2, (boolean)string.contains(string2));
        string2 = System.getProperty("java.version");
        Assert.assertTrue((String)string2, (boolean)string.contains(string2));
        string2 = System.getProperty("os.name");
        Assert.assertTrue((String)string2, (boolean)string.contains(string2));
        string2 = System.getProperty("user.home");
        Assert.assertTrue((String)string2, (boolean)string.contains(string2));
    }

    @Test
    public void testBrief() throws Exception {
        AboutSC aboutSC = new AboutSC(0, new String[]{"TEST", "--brief"});
        aboutSC.run();
        String string = ((CharSequence)TestUtilities.getSingleton((Object[])CharSequences.splitOnEOL((CharSequence)aboutSC.outputBuffer.toString().trim()))).toString();
        Assert.assertTrue((String)string, (boolean)string.contains(Version.SIS.toString()));
    }

    @Test
    public void testVerbose() throws Exception {
        AboutSC aboutSC = new AboutSC(0, new String[]{"TEST", "--verbose"});
        aboutSC.run();
        String string = aboutSC.outputBuffer.toString();
        AboutSCTest.verify(string);
        Assert.assertTrue((String)"geoapi", (boolean)string.contains("geoapi"));
    }

    @Test
    public void testToRemoveURL() {
        Assert.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://myhost:9999/jmxrmi", (Object)AboutSC.toRemoveURL((String)"myhost:9999"));
        Assert.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://myhost:1099/jmxrmi", (Object)AboutSC.toRemoveURL((String)"myhost"));
        Assert.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object)AboutSC.toRemoveURL((String)"localhost:9999"));
        Assert.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://:1099/jmxrmi", (Object)AboutSC.toRemoveURL((String)"localhost"));
        Assert.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object)AboutSC.toRemoveURL((String)":9999"));
        Assert.assertEquals((Object)"service:jmx:rmi:///jndi/rmi://localhosx:1099/jmxrmi", (Object)AboutSC.toRemoveURL((String)"localhosx"));
    }
}

