/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.sirona.agent.webapp.pull.store;

import org.apache.sirona.store.DelegateDataStoreFactory;
import org.apache.sirona.store.memory.counter.InMemoryCounterDataStore;
import org.apache.sirona.store.memory.gauge.InMemoryGaugeDataStore;
import org.apache.sirona.store.status.EmptyStatuses;
import org.apache.sirona.store.memory.tracking.InMemoryPathTrackingDataStore;

public class PullDataStoreFactory
    extends DelegateDataStoreFactory
{
    public PullDataStoreFactory()
    {
        super( new InMemoryCounterDataStore(), //
               new InMemoryGaugeDataStore(), //
               new EmptyStatuses(), //
               new InMemoryPathTrackingDataStore() );
    }
}
