/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.jpa;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.jpa.JPAProxyFactory;
import org.apache.sirona.jpa.OverridePersistenceXmlClassLoader;

public class SironaPersistence
implements PersistenceProvider {
    public static final Role ROLE = new Role("jpa", Unit.Time.NANOSECOND);
    private static final String DELEGATE_PROVIDER_KEY = "org.apache.sirona.jpa.provider";
    private static final String DEFAULT_PROVIDER = System.getProperty("org.apache.sirona.jpa.provider");
    private static final Class<?>[] PROXY_API = new Class[]{EntityManagerFactory.class, Serializable.class};
    private static final String[] PROVIDERS = new String[]{"org.apache.openjpa.persistence.PersistenceProviderImpl", "org.hibernate.jpa.HibernatePersistenceProvider", "org.hibernate.ejb.HibernatePersistence", "org.eclipse.persistence.jpa.PersistenceProvider", "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider", "oracle.toplink.essentials.PersistenceProvider", "me.prettyprint.hom.CassandraPersistenceProvider", "org.datanucleus.jpa.PersistenceProviderImpl", "com.orientechnologies.orient.core.db.object.jpa.OJPAPersistenceProvider", "com.orientechnologies.orient.object.jpa.OJPAPersistenceProvider", "com.spaceprogram.simplejpa.PersistenceProviderImpl"};
    private volatile PersistenceProvider delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(String unit, Map map) {
        PersistenceProvider persistenceProvider = this.findDelegate(map);
        ClassLoader tccl = SironaPersistence.tccl();
        OverridePersistenceXmlClassLoader hack = new OverridePersistenceXmlClassLoader(tccl, persistenceProvider.getClass().getName());
        Thread.currentThread().setContextClassLoader(hack);
        try {
            EntityManagerFactory entityManagerFactory = persistenceProvider.createEntityManagerFactory(unit, map);
            if (entityManagerFactory == null) {
                EntityManagerFactory entityManagerFactory2 = null;
                return entityManagerFactory2;
            }
            EntityManagerFactory entityManagerFactory3 = (EntityManagerFactory)EntityManagerFactory.class.cast(JPAProxyFactory.monitor(PROXY_API, entityManagerFactory, ROLE, true));
            return entityManagerFactory3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        PersistenceProvider persistenceProvider = this.findDelegate(map);
        EntityManagerFactory containerEntityManagerFactory = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)PersistenceUnitInfo.class.cast(Proxy.newProxyInstance(SironaPersistence.tccl(), new Class[]{PersistenceUnitInfo.class}, (InvocationHandler)new ProviderAwareHandler(persistenceProvider.getClass().getName(), info))), map);
        if (containerEntityManagerFactory == null) {
            return null;
        }
        return (EntityManagerFactory)EntityManagerFactory.class.cast(JPAProxyFactory.monitor(PROXY_API, containerEntityManagerFactory, ROLE, true));
    }

    public ProviderUtil getProviderUtil() {
        return this.loadOrGuessDelegate(null).getProviderUtil();
    }

    private PersistenceProvider findDelegate(Map map) {
        if (map == null) {
            return this.loadOrGuessDelegate(null);
        }
        return this.loadOrGuessDelegate((String)String.class.cast(map.get(DELEGATE_PROVIDER_KEY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceProvider loadOrGuessDelegate(String name) {
        if (this.delegate == null) {
            SironaPersistence sironaPersistence = this;
            synchronized (sironaPersistence) {
                if (this.delegate == null) {
                    if (name == null) {
                        if (DEFAULT_PROVIDER != null) {
                            try {
                                this.delegate = SironaPersistence.newPersistence(DEFAULT_PROVIDER);
                            }
                            catch (Exception e) {
                                throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + DEFAULT_PROVIDER + "'"));
                            }
                        } else {
                            for (String provider : PROVIDERS) {
                                try {
                                    this.delegate = SironaPersistence.newPersistence(provider);
                                    if (this.delegate == null) continue;
                                    break;
                                }
                                catch (Throwable th2) {
                                    // empty catch block
                                }
                            }
                        }
                        if (this.delegate == null) {
                            throw new IllegalStateException(new ClassNotFoundException("Can't find a delegate"));
                        }
                    } else {
                        try {
                            this.delegate = SironaPersistence.newPersistence(name);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + name + "'"));
                        }
                    }
                }
            }
        }
        if (name != null && !this.delegate.getClass().getName().equals(name)) {
            try {
                return SironaPersistence.newPersistence(name);
            }
            catch (Exception e) {
                throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + name + "'"));
            }
        }
        return this.delegate;
    }

    private static ClassLoader tccl() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static PersistenceProvider newPersistence(String name) throws Exception {
        return (PersistenceProvider)PersistenceProvider.class.cast(SironaPersistence.tccl().loadClass(name).newInstance());
    }

    private static class ProviderAwareHandler
    implements InvocationHandler {
        private final String provider;
        private final PersistenceUnitInfo info;

        public ProviderAwareHandler(String provider, PersistenceUnitInfo info) {
            this.provider = provider;
            this.info = info;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getPersistenceProviderClassName".equals(method.getName())) {
                return this.provider;
            }
            return method.invoke((Object)this.info, args);
        }
    }
}

