/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.jpa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import org.apache.sirona.SironaException;
import org.apache.sirona.jpa.SironaPersistence;

public class OverridePersistenceXmlClassLoader
extends ClassLoader {
    private static final String PERSISTENCE_XML = "META-INF/persistence.xml";
    private static final String PERSISTENCE_PROVIDER = SironaPersistence.class.getName();
    public static final String NO_PROVIDER = "<provider></provider>";
    private final String replacement;

    public OverridePersistenceXmlClassLoader(ClassLoader parent, String replacement) {
        super(parent);
        this.replacement = replacement;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        URL url = super.getResource(name);
        if (PERSISTENCE_XML.equals(name) && url != null) {
            return this.newUrl(url, OverridePersistenceXmlClassLoader.slurp(url));
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> urls = super.getResources(name);
        if (PERSISTENCE_XML.equals(name)) {
            LinkedList<URL> overrided = new LinkedList<URL>();
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                overrided.add(this.newUrl(url, OverridePersistenceXmlClassLoader.slurp(url)));
            }
            return Collections.enumeration(overrided);
        }
        return urls;
    }

    private URL newUrl(URL url, String slurp) {
        if (slurp.contains(PERSISTENCE_PROVIDER)) {
            String afterReplace = slurp.replace(PERSISTENCE_PROVIDER, this.replacement).replace(NO_PROVIDER, "");
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), new ConstantURLStreamHandler(afterReplace));
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return url;
    }

    private static String slurp(URL url) {
        InputStream is = null;
        try {
            int length;
            is = url.openStream();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
            String string = new String(out.toByteArray());
            return string;
        }
        catch (IOException e) {
            throw new SironaException((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static class ConstantURLConnection
    extends URLConnection {
        private final String value;

        private ConstantURLConnection(URL url, String value) {
            super(url);
            this.value = value;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.value.getBytes());
        }
    }

    private static class ConstantURLStreamHandler
    extends URLStreamHandler {
        private final String value;

        private ConstantURLStreamHandler(String value) {
            this.value = value;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new ConstantURLConnection(u, this.value);
        }
    }
}

