/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.jpa;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.sirona.Role;
import org.apache.sirona.aop.AbstractPerformanceInterceptor;
import org.apache.sirona.util.ClassLoaders;

public final class JPAProxyFactory {
    public static Object monitor(Class<?>[] classes, Object instance, Role role, boolean cascade) {
        return classes[0].cast(Proxy.newProxyInstance(ClassLoaders.current(), classes, (InvocationHandler)new JSEMonitoringHandler(instance, role, cascade)));
    }

    private JPAProxyFactory() {
    }

    private static class Invocation {
        private final Object target;
        private final Method method;
        private final Object[] args;

        private Invocation(Object target, Method method, Object[] args) {
            this.target = target;
            this.method = method;
            this.args = args;
        }
    }

    private static class JSEMonitoringHandler
    extends AbstractPerformanceInterceptor<Invocation>
    implements InvocationHandler {
        private final Object instance;
        private final Role role;
        private final boolean cascade;

        public JSEMonitoringHandler(Object instance, Role role, boolean cascade) {
            this.instance = instance;
            this.role = role;
            this.cascade = cascade;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("toString".equals(method.getName())) {
                return "MonitoringProxy[" + this.instance + "]";
            }
            Object o = this.doInvoke(new Invocation(this.instance, method, args));
            Class<?> returnType = method.getReturnType();
            if (this.cascade && returnType.isInterface()) {
                return JPAProxyFactory.monitor(this.classes(returnType, o), o, this.role, true);
            }
            return o;
        }

        protected Object proceed(Invocation invocation) throws Throwable {
            try {
                return invocation.method.invoke(invocation.target, invocation.args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }

        protected String getCounterName(Invocation invocation) {
            return this.getCounterName(invocation.target, invocation.method);
        }

        protected Role getRole() {
            return this.role;
        }

        protected Class<?>[] classes(Class<?> returnType, Object o) {
            if (Serializable.class.isInstance(o)) {
                return new Class[]{returnType, Serializable.class};
            }
            return new Class[]{returnType};
        }
    }
}

