/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.agent.jaxrs.cxf;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.ext.RequestHandler;
import org.apache.cxf.jaxrs.ext.ResponseHandler;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.message.Message;
import org.apache.sirona.Role;
import org.apache.sirona.aop.AbstractPerformanceInterceptor;

@Provider
public class CxfJaxRsPerformanceHandler
extends AbstractPerformanceInterceptor<Message>
implements RequestHandler,
ResponseHandler {
    public static final Role ROLE = new Role(Role.PERFORMANCES.getName() + "-cxf26", Role.PERFORMANCES.getUnit());
    private static final String PROP_KEY = AbstractPerformanceInterceptor.Context.class.getName();
    private static final String NO_METHOD = "X";

    public Response handleRequest(Message m, ClassResourceInfo resourceClass) {
        Object rest = m.getContextualProperty("org.apache.cxf.rest.message");
        if (rest != null && Boolean.TRUE.equals(rest)) {
            m.getExchange().put((Object)PROP_KEY, (Object)this.before(m, this.getCounterName(m)));
        }
        return null;
    }

    public Response handleResponse(Message m, OperationResourceInfo ori, Response response) {
        AbstractPerformanceInterceptor.Context context = (AbstractPerformanceInterceptor.Context)AbstractPerformanceInterceptor.Context.class.cast(m.getExchange().get((Object)PROP_KEY));
        if (context != null) {
            context.stop();
        }
        return null;
    }

    protected String getCounterName(Message message) {
        OperationResourceInfo ori = (OperationResourceInfo)message.getExchange().get(OperationResourceInfo.class);
        String method = ori.getHttpMethod();
        if (method == null) {
            method = NO_METHOD;
        }
        StringBuilder builder = new StringBuilder(method).append("-");
        builder.append(message.getContextualProperty("org.apache.cxf.message.Message.BASE_PATH"));
        URITemplate classTpl = ori.getClassResourceInfo().getURITemplate();
        if (classTpl != null) {
            builder.append(classTpl.getValue());
        }
        builder.append(ori.getURITemplate().getValue());
        return builder.toString().replace("//", "/");
    }

    protected Object proceed(Message invocation) throws Throwable {
        throw new UnsupportedOperationException("shouldn't be called");
    }

    protected Role getRole() {
        return ROLE;
    }
}

