/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.collector.server;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sirona.Role;
import org.apache.sirona.SironaException;
import org.apache.sirona.collector.server.AgentNode;
import org.apache.sirona.collector.server.Event;
import org.apache.sirona.collector.server.api.SSLSocketFactoryProvider;
import org.apache.sirona.collector.server.api.SecurityProvider;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.IoCs;
import org.apache.sirona.counters.Counter;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.math.M2AwareStatisticalSummary;
import org.apache.sirona.repositories.Repository;
import org.apache.sirona.status.NodeStatus;
import org.apache.sirona.status.Status;
import org.apache.sirona.status.ValidationResult;
import org.apache.sirona.store.BatchFuture;
import org.apache.sirona.store.counter.CollectorCounterStore;
import org.apache.sirona.store.gauge.CollectorGaugeDataStore;
import org.apache.sirona.store.status.CollectorNodeStatusDataStore;
import org.apache.sirona.store.status.NodeStatusDataStore;
import org.apache.sirona.store.tracking.CollectorPathTrackingDataStore;
import org.apache.sirona.tracking.PathTrackingEntry;
import org.apache.sirona.util.DaemonThreadFactory;
import org.apache.sirona.util.SerializeUtils;

public class Collector
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(Collector.class.getName());
    private static final String OK = "{}";
    private static final String GAUGE = "gauge";
    private static final String COUNTER = "counter";
    private static final String VALIDATION = "validation";
    private static final String STATUS = "status";
    private static final String REGISTRATION = "registration";
    private static final String PATH_TRACKING = "pathtracking";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JAVA_OBJECT = "application/x-java-serialized-object";
    private static final String X_SIRONA_CLASSNAME = "X-Sirona-ClassName";
    private static final String GET = "GET";
    private final Map<String, Role> roles = new ConcurrentHashMap<String, Role>();
    private CollectorCounterStore counterDataStore = null;
    private CollectorGaugeDataStore gaugeDataStore = null;
    private CollectorNodeStatusDataStore statusDataStore;
    private CollectorPathTrackingDataStore pathTrackingDataStore;
    private ObjectMapper mapper;
    private final Collection<AgentNode> agents = new CopyOnWriteArraySet<AgentNode>();
    private volatile BatchFuture collectionFuture = null;
    private long collectionPeriod;
    private SecurityProvider securityProvider;
    private SSLSocketFactoryProvider sslSocketFactoryProvider;
    private boolean disableDisruptor;
    private RingBuffer<PathTrackingEntry> ringBuffer;
    private Disruptor<PathTrackingEntry> disruptor;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        IoCs.findOrCreateInstance(Repository.class);
        CollectorGaugeDataStore gds = (CollectorGaugeDataStore)IoCs.findOrCreateInstance(CollectorGaugeDataStore.class);
        if (gds == null) {
            throw new IllegalStateException("Collector only works with " + CollectorGaugeDataStore.class.getName());
        }
        this.gaugeDataStore = (CollectorGaugeDataStore)CollectorGaugeDataStore.class.cast(gds);
        CollectorCounterStore cds = (CollectorCounterStore)IoCs.findOrCreateInstance(CollectorCounterStore.class);
        if (cds == null) {
            throw new IllegalStateException("Collector only works with " + CollectorCounterStore.class.getName());
        }
        this.counterDataStore = (CollectorCounterStore)CollectorCounterStore.class.cast(cds);
        NodeStatusDataStore nds = (NodeStatusDataStore)IoCs.findOrCreateInstance(CollectorNodeStatusDataStore.class);
        if (!CollectorNodeStatusDataStore.class.isInstance(nds)) {
            throw new IllegalStateException("Collector only works with " + CollectorNodeStatusDataStore.class.getName());
        }
        this.statusDataStore = (CollectorNodeStatusDataStore)CollectorNodeStatusDataStore.class.cast(nds);
        this.pathTrackingDataStore = (CollectorPathTrackingDataStore)IoCs.findOrCreateInstance(CollectorPathTrackingDataStore.class);
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS, true);
        String periodKey = "org.apache.sirona.collector.collection.period";
        String collectionPeriodStr = sc.getInitParameter("org.apache.sirona.collector.collection.period");
        this.collectionPeriod = collectionPeriodStr != null ? (long)Integer.parseInt(collectionPeriodStr) : (long)Configuration.getInteger((String)"org.apache.sirona.collector.collection.period", (int)60000);
        String agentUrlsKey = "org.apache.sirona.collector.collection.agent-urls";
        for (String agents : new String[]{Configuration.getProperty((String)"org.apache.sirona.collector.collection.agent-urls", null), sc.getInitParameter("org.apache.sirona.collector.collection.agent-urls")}) {
            if (agents == null) continue;
            for (String url : agents.split(",")) {
                try {
                    this.registerNode(url.trim());
                }
                catch (MalformedURLException e) {
                    throw new SironaException((Throwable)e);
                }
            }
        }
        try {
            this.securityProvider = (SecurityProvider)IoCs.findOrCreateInstance(SecurityProvider.class);
        }
        catch (Exception e) {
            this.securityProvider = null;
        }
        try {
            this.sslSocketFactoryProvider = (SSLSocketFactoryProvider)IoCs.findOrCreateInstance(SSLSocketFactoryProvider.class);
        }
        catch (Exception e) {
            this.sslSocketFactoryProvider = null;
        }
        String key = "org.apache.sirona.collector.pathtracking.disabledisruptor";
        this.disableDisruptor = Boolean.parseBoolean(Configuration.getProperty((String)key, (String)"false"));
        if (!this.disableDisruptor) {
            ExecutorService exec = Executors.newCachedThreadPool();
            key = "org.apache.sirona.collector.pathtracking.disruptor.ringBufferSize";
            int ringBufferSize = Configuration.getInteger((String)key, (int)4096);
            key = "org.apache.sirona.collector.pathtracking.disruptor.numberOfConsumers";
            int numberOfConsumers = Configuration.getInteger((String)key, (int)4);
            this.disruptor = new Disruptor((EventFactory)new EventFactory<PathTrackingEntry>(){

                public PathTrackingEntry newInstance() {
                    return new PathTrackingEntry();
                }
            }, ringBufferSize, (Executor)exec, ProducerType.SINGLE, (WaitStrategy)new BusySpinWaitStrategy());
            for (int i = 0; i < numberOfConsumers; ++i) {
                this.disruptor.handleEventsWith(new EventHandler[]{new PathTrackingEntryEventHandler(i, numberOfConsumers, this.pathTrackingDataStore)});
            }
            this.ringBuffer = this.disruptor.start();
        }
    }

    public void destroy() {
        if (this.collectionFuture != null) {
            this.collectionFuture.done();
        }
        if (this.disruptor != null) {
            try {
                this.disruptor.shutdown(1000L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletInputStream inputStream = req.getInputStream();
        try {
            if (APPLICATION_JAVA_OBJECT.equals(req.getHeader(CONTENT_TYPE))) {
                if (PathTrackingEntry.class.getName().equals(req.getHeader(X_SIRONA_CLASSNAME))) {
                    int length = req.getContentLength();
                    this.updatePathTracking(this.readBytes(req.getInputStream(), length));
                }
            } else if ("gzip".equals(req.getHeader(CONTENT_ENCODING))) {
                this.slurpEvents(new GZIPInputStream((InputStream)inputStream));
            } else {
                this.slurpEvents((InputStream)inputStream);
            }
        }
        catch (SironaException me) {
            resp.setStatus(400);
            resp.getWriter().write("{\"error\":\"" + me.getCause().getMessage().replace('\"', ' ') + "\"}");
            return;
        }
        resp.setStatus(200);
        resp.getWriter().write(OK);
    }

    private byte[] readBytes(ServletInputStream servletInputStream, int length) throws IOException {
        int nRead;
        byte[] bytes = new byte[length];
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(length);
        while ((nRead = servletInputStream.read(bytes, 0, bytes.length)) != -1) {
            buffer.write(bytes, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    private void slurpEvents(InputStream inputStream) throws IOException {
        Event[] events = (Event[])this.mapper.readValue(inputStream, Event[].class);
        if (events != null && events.length > 0) {
            try {
                LinkedList<Event> validations = new LinkedList<Event>();
                long date = -1L;
                for (Event event : events) {
                    String type = event.getType();
                    if (VALIDATION.equals(type)) {
                        validations.add(event);
                        continue;
                    }
                    if (STATUS.equals(type)) {
                        date = ((Number)Number.class.cast(event.getData().get("date"))).longValue();
                        continue;
                    }
                    if (COUNTER.equals(type)) {
                        this.updateCounter(event);
                        continue;
                    }
                    if (GAUGE.equals(type)) {
                        this.updateGauge(event);
                        continue;
                    }
                    if (REGISTRATION.equals(type)) {
                        this.registerNode(event);
                        continue;
                    }
                    if (PATH_TRACKING.equals(type)) {
                        this.updatePathTracking(event);
                        continue;
                    }
                    LOGGER.info("Unexpected type '" + type + "', skipping");
                }
                if (validations.size() > 0) {
                    ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(validations.size());
                    for (Event event : validations) {
                        Map<String, Object> data = event.getData();
                        results.add(new ValidationResult((String)data.get("name"), Status.valueOf((String)((String)data.get(STATUS))), (String)data.get("message")));
                    }
                    Date statusDate = date == -1L ? new Date() : new Date(date);
                    NodeStatus status = new NodeStatus(results.toArray(new ValidationResult[results.size()]), statusDate);
                    this.statusDataStore.store((String)events[0].getData().get("marker"), status);
                }
            }
            catch (Exception e) {
                throw new SironaException((Throwable)e);
            }
        }
    }

    private void registerNode(Event event) throws MalformedURLException {
        this.registerNode((String)String.class.cast(event.getData().get("url")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNode(String url) throws MalformedURLException {
        if (url == null) {
            return;
        }
        AgentNode node = new AgentNode(url);
        if (this.agents.add(node) && this.collectionFuture == null) {
            Collector collector = this;
            synchronized (collector) {
                if (this.collectionFuture == null) {
                    ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory("collector-pull-schedule"));
                    ScheduledFuture<?> future = ses.scheduleAtFixedRate(new CollectTask(), this.collectionPeriod, this.collectionPeriod, TimeUnit.MILLISECONDS);
                    this.collectionFuture = new BatchFuture(ses, future);
                }
            }
        }
    }

    private void updateGauge(Event event) {
        Map<String, Object> data = event.getData();
        long time = event.getTime().getTime();
        double value = ((Number)Number.class.cast(data.get("value"))).doubleValue();
        this.gaugeDataStore.addToGauge(this.role(data), time, value, (String)String.class.cast(data.get("marker")));
    }

    private void updatePathTracking(Event event) {
        Map<String, Object> data = event.getData();
        final PathTrackingEntry pathTrackingEntry = new PathTrackingEntry((String)String.class.cast(data.get("trackingId")), (String)String.class.cast(data.get("nodeId")), (String)String.class.cast(data.get("className")), (String)String.class.cast(data.get("methodName")), ((Number)Number.class.cast(data.get("startTime"))).longValue(), ((Number)Number.class.cast(data.get("executionTime"))).longValue(), ((Number)Number.class.cast(data.get("level"))).intValue());
        if (this.disableDisruptor) {
            this.pathTrackingDataStore.store(pathTrackingEntry);
        } else {
            this.ringBuffer.publishEvent((EventTranslator)new EventTranslator<PathTrackingEntry>(){

                public void translateTo(PathTrackingEntry event, long sequence) {
                    event.setClassName(pathTrackingEntry.getClassName());
                    event.setExecutionTime(pathTrackingEntry.getExecutionTime());
                    event.setLevel(pathTrackingEntry.getLevel());
                    event.setMethodName(pathTrackingEntry.getMethodName());
                    event.setNodeId(pathTrackingEntry.getNodeId());
                    event.setStartTime(pathTrackingEntry.getStartTime());
                    event.setTrackingId(pathTrackingEntry.getTrackingId());
                }
            });
        }
    }

    private void updatePathTracking(byte[] bytes) {
        final PathTrackingEntry pathTrackingEntry = (PathTrackingEntry)SerializeUtils.deserialize((byte[])bytes, PathTrackingEntry.class);
        if (this.disableDisruptor) {
            this.pathTrackingDataStore.store(pathTrackingEntry);
        } else {
            this.ringBuffer.publishEvent((EventTranslator)new EventTranslator<PathTrackingEntry>(){

                public void translateTo(PathTrackingEntry event, long sequence) {
                    event.setClassName(pathTrackingEntry.getClassName());
                    event.setExecutionTime(pathTrackingEntry.getExecutionTime());
                    event.setLevel(pathTrackingEntry.getLevel());
                    event.setMethodName(pathTrackingEntry.getMethodName());
                    event.setNodeId(pathTrackingEntry.getNodeId());
                    event.setStartTime(pathTrackingEntry.getStartTime());
                    event.setTrackingId(pathTrackingEntry.getTrackingId());
                }
            });
        }
    }

    private void updateCounter(Event event) {
        Map<String, Object> data = event.getData();
        this.counterDataStore.update(new Counter.Key(this.role(data), (String)String.class.cast(data.get("name"))), (String)String.class.cast(data.get("marker")), new M2AwareStatisticalSummary(data), ((Number)Number.class.cast(data.get("concurrency"))).intValue());
    }

    private Role role(Map<String, Object> data) {
        String name = (String)String.class.cast(data.get("role"));
        Role existing = this.roles.get(name);
        if (existing != null) {
            return existing;
        }
        Role created = new Role(name, Unit.get((String)((String)String.class.cast(data.get("unit")))));
        this.roles.put(name, created);
        return created;
    }

    private class CollectTask
    implements Runnable {
        private CollectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Iterator nodes = Collector.this.agents.iterator();
            while (nodes.hasNext()) {
                AgentNode agent = (AgentNode)nodes.next();
                try {
                    String auth;
                    SSLSocketFactory sf;
                    URL url = agent.getUrl();
                    HttpURLConnection connection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
                    if (Collector.this.sslSocketFactoryProvider != null && (sf = Collector.this.sslSocketFactoryProvider.sslSocketFactory(url.toExternalForm())) != null && "https".equals(agent.getUrl().getProtocol())) {
                        ((HttpsURLConnection)HttpsURLConnection.class.cast(connection)).setSSLSocketFactory(sf);
                    }
                    if (Collector.this.securityProvider != null && (auth = Collector.this.securityProvider.basicHeader(url.toExternalForm())) != null) {
                        connection.setRequestProperty("Authorization", auth);
                    }
                    connection.setRequestMethod(Collector.GET);
                    InputStream inputStream = null;
                    try {
                        inputStream = connection.getInputStream();
                        Collector.this.slurpEvents(inputStream);
                    }
                    finally {
                        connection.disconnect();
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                    int status = connection.getResponseCode();
                    if (status / 100 == 2) {
                        agent.ok();
                    } else {
                        agent.ko();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    agent.ko();
                }
                if (!agent.isDead()) continue;
                nodes.remove();
            }
        }
    }

    private static class PathTrackingEntryEventHandler
    implements EventHandler<PathTrackingEntry> {
        private final long ordinal;
        private final long numberOfConsumers;
        private final CollectorPathTrackingDataStore pathTrackingDataStore;

        public PathTrackingEntryEventHandler(long ordinal, long numberOfConsumers, CollectorPathTrackingDataStore pathTrackingDataStore) {
            this.ordinal = ordinal;
            this.numberOfConsumers = numberOfConsumers;
            this.pathTrackingDataStore = pathTrackingDataStore;
        }

        public void onEvent(PathTrackingEntry entry, long sequence, boolean endOfBatch) throws Exception {
            if (sequence % this.numberOfConsumers == this.ordinal) {
                this.pathTrackingDataStore.store(entry);
            }
        }
    }
}

