/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.cache.jcache;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.lang.util.Destroyable;
import org.apache.shiro.lang.util.Initializable;
import org.apache.shiro.lang.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheManager
implements CacheManager,
Initializable,
Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JCacheManager.class);
    private javax.cache.CacheManager jCacheManager;
    private String cacheConfig;
    private boolean cacheManagerImplicitlyCreated;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> Cache<K, V> getCache(String name) throws CacheException {
        javax.cache.Cache cache = this.ensureCacheManager().getCache(name);
        if (cache == null) {
            JCacheManager jCacheManager = this;
            synchronized (jCacheManager) {
                cache = this.ensureCacheManager().getCache(name);
                if (cache == null) {
                    LOGGER.debug("Cache with name '{}' does not yet exist.  Creating now.", (Object)name);
                    cache = this.ensureCacheManager().createCache(name, (Configuration)new MutableConfiguration());
                    LOGGER.debug("Added JCache named [{}]", (Object)name);
                } else {
                    LOGGER.debug("Using existing JCache named [{}]", (Object)cache.getName());
                }
            }
        }
        return new JCache(cache);
    }

    public final void init() throws CacheException {
        this.ensureCacheManager();
    }

    private javax.cache.CacheManager ensureCacheManager() {
        try {
            if (this.jCacheManager == null) {
                LOGGER.debug("cacheManager property not set.  Constructing CacheManager instance... ");
                CachingProvider cachingProvider = Caching.getCachingProvider();
                if (StringUtils.hasText((String)this.cacheConfig)) {
                    URL config = this.getClass().getResource(this.cacheConfig);
                    if (config == null) {
                        throw new IllegalArgumentException("Could not load JCache configuration resource: " + this.cacheConfig);
                    }
                    this.jCacheManager = cachingProvider.getCacheManager(config.toURI(), this.getClass().getClassLoader());
                } else {
                    this.jCacheManager = cachingProvider.getCacheManager();
                }
                this.cacheManagerImplicitlyCreated = true;
                LOGGER.debug("implicit cacheManager created successfully.");
            }
            return this.jCacheManager;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void destroy() {
        if (this.cacheManagerImplicitlyCreated) {
            try {
                this.jCacheManager.close();
            }
            catch (Throwable t) {
                LOGGER.warn("Unable to cleanly shutdown implicitly created CacheManager instance. Ignoring (shutting down)...", t);
            }
            finally {
                this.jCacheManager = null;
                this.cacheManagerImplicitlyCreated = false;
            }
        }
    }

    public String getCacheConfig() {
        return this.cacheConfig;
    }

    public void setCacheConfig(String jCacheConfig) {
        this.cacheConfig = jCacheConfig;
    }

    public javax.cache.CacheManager getCacheManager() {
        return this.jCacheManager;
    }

    public void setCacheManager(javax.cache.CacheManager jCacheManager) {
        this.jCacheManager = jCacheManager;
    }

    static class JCache<K, V>
    implements Cache<K, V> {
        private final javax.cache.Cache<K, V> cache;

        JCache(javax.cache.Cache<K, V> cache) {
            this.cache = cache;
        }

        public V get(K key) throws CacheException {
            try {
                LOGGER.trace("Getting object from cache [{}] for key [{}]", (Object)this.cache.getName(), key);
                if (key == null) {
                    return null;
                }
                Object element = this.cache.get(key);
                if (element == null) {
                    LOGGER.trace("Element for [{}] is null.", key);
                    return null;
                }
                return (V)element;
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }

        public V put(K key, V value) throws CacheException {
            LOGGER.trace("Putting object in cache [{}] for key [{}]", (Object)this.cache.getName(), key);
            try {
                V previous = this.get(key);
                this.cache.put(key, value);
                return previous;
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }

        public V remove(K key) throws CacheException {
            LOGGER.trace("Removing object from cache [{}] for key [{}]", (Object)this.cache.getName(), key);
            try {
                return (V)this.cache.getAndRemove(key);
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }

        public void clear() throws CacheException {
            LOGGER.trace("Clearing all objects from cache [{}]", (Object)this.cache.getName());
            try {
                this.cache.removeAll();
            }
            catch (Throwable t) {
                throw new CacheException(t);
            }
        }

        public int size() {
            return (int)this.toStream(this.cache.iterator()).count();
        }

        public Set<K> keys() {
            return this.toStream(this.cache.iterator()).map(Cache.Entry::getKey).collect(Collectors.toSet());
        }

        public Collection<V> values() {
            return this.toStream(this.cache.iterator()).map(Cache.Entry::getValue).collect(Collectors.toSet());
        }

        private Stream<Cache.Entry<K, V>> toStream(Iterator<Cache.Entry<K, V>> iterator) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        }
    }
}

