/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.guice.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Iterator;

class SimpleFilterChain
implements FilterChain {
    private final FilterChain originalChain;
    private final Iterator<? extends Filter> chain;
    private boolean originalCalled = false;

    public SimpleFilterChain(FilterChain originalChain, Iterator<? extends Filter> chain) {
        this.originalChain = originalChain;
        this.chain = chain;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.chain.hasNext()) {
            Filter filter = this.chain.next();
            filter.doFilter(request, response, (FilterChain)this);
        } else if (!this.originalCalled) {
            this.originalCalled = true;
            this.originalChain.doFilter(request, response);
        }
    }

    Iterator<? extends Filter> getFilters() {
        return this.chain;
    }
}

