/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import java.util.function.Supplier;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.RememberMeAuthenticationToken;
import org.apache.shiro.crypto.cipher.AesCipherService;
import org.apache.shiro.crypto.cipher.ByteSourceBroker;
import org.apache.shiro.crypto.cipher.CipherService;
import org.apache.shiro.lang.io.DefaultSerializer;
import org.apache.shiro.lang.io.Serializer;
import org.apache.shiro.lang.util.ByteSource;
import org.apache.shiro.lang.util.ByteUtils;
import org.apache.shiro.mgt.RememberMeManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRememberMeManager
implements RememberMeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRememberMeManager.class);
    private Serializer<PrincipalCollection> serializer = new DefaultSerializer();
    private CipherService cipherService = new AesCipherService();
    private byte[] encryptionCipherKey;
    private byte[] decryptionCipherKey;

    public AbstractRememberMeManager() {
        this.setCipherKey(((AesCipherService)this.cipherService).generateNewKey().getEncoded());
    }

    public AbstractRememberMeManager(Supplier<byte[]> keySupplier) {
        this();
        this.setCipherKey(keySupplier.get());
    }

    public Serializer<PrincipalCollection> getSerializer() {
        return this.serializer;
    }

    public void setSerializer(Serializer<PrincipalCollection> serializer) {
        this.serializer = serializer;
    }

    public CipherService getCipherService() {
        return this.cipherService;
    }

    public void setCipherService(CipherService cipherService) {
        this.cipherService = cipherService;
    }

    public byte[] getEncryptionCipherKey() {
        return this.encryptionCipherKey;
    }

    public void setEncryptionCipherKey(byte[] encryptionCipherKey) {
        this.encryptionCipherKey = encryptionCipherKey;
    }

    public byte[] getDecryptionCipherKey() {
        return this.decryptionCipherKey;
    }

    public void setDecryptionCipherKey(byte[] decryptionCipherKey) {
        this.decryptionCipherKey = decryptionCipherKey;
    }

    public byte[] getCipherKey() {
        return this.getEncryptionCipherKey();
    }

    public void setCipherKey(byte[] cipherKey) {
        this.setEncryptionCipherKey(cipherKey);
        this.setDecryptionCipherKey(cipherKey);
    }

    protected abstract void forgetIdentity(Subject var1);

    protected boolean isRememberMe(AuthenticationToken token) {
        return token instanceof RememberMeAuthenticationToken && ((RememberMeAuthenticationToken)token).isRememberMe();
    }

    @Override
    public void onSuccessfulLogin(Subject subject, AuthenticationToken token, AuthenticationInfo info) {
        this.forgetIdentity(subject);
        if (this.isRememberMe(token)) {
            this.rememberIdentity(subject, token, info);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AuthenticationToken did not indicate RememberMe is requested.  RememberMe functionality will not be executed for corresponding account.");
        }
    }

    public void rememberIdentity(Subject subject, AuthenticationToken token, AuthenticationInfo authcInfo) {
        PrincipalCollection principals = this.getIdentityToRemember(subject, authcInfo);
        this.rememberIdentity(subject, principals);
    }

    protected PrincipalCollection getIdentityToRemember(Subject subject, AuthenticationInfo info) {
        return info.getPrincipals();
    }

    protected void rememberIdentity(Subject subject, PrincipalCollection accountPrincipals) {
        byte[] bytes = this.convertPrincipalsToBytes(accountPrincipals);
        this.rememberSerializedIdentity(subject, bytes);
    }

    protected byte[] convertPrincipalsToBytes(PrincipalCollection principals) {
        byte[] bytes = this.serialize(principals);
        if (this.getCipherService() != null) {
            bytes = this.encrypt(bytes);
        }
        return bytes;
    }

    protected abstract void rememberSerializedIdentity(Subject var1, byte[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrincipalCollection getRememberedPrincipals(SubjectContext subjectContext) {
        PrincipalCollection principals = null;
        byte[] bytes = null;
        try {
            bytes = this.getRememberedSerializedIdentity(subjectContext);
            if (bytes != null && bytes.length > 0) {
                principals = this.convertBytesToPrincipals(bytes, subjectContext);
            }
        }
        catch (RuntimeException re) {
            principals = this.onRememberedPrincipalFailure(re, subjectContext);
        }
        finally {
            ByteUtils.wipe((Object)bytes);
        }
        return principals;
    }

    protected abstract byte[] getRememberedSerializedIdentity(SubjectContext var1);

    protected PrincipalCollection convertBytesToPrincipals(byte[] bytes, SubjectContext subjectContext) {
        if (this.getCipherService() != null) {
            bytes = this.decrypt(bytes);
        }
        return this.deserialize(bytes);
    }

    protected PrincipalCollection onRememberedPrincipalFailure(RuntimeException e, SubjectContext context) {
        if (LOGGER.isWarnEnabled()) {
            String message = "There was a failure while trying to retrieve remembered principals.  This could be due to a configuration problem or corrupted principals.  This could also be due to a recently changed encryption key, if you are using a shiro.ini file, this property would be 'securityManager.rememberMeManager.cipherKey'see: http://shiro.apache.org/web.html#Web-RememberMeServices. The remembered identity will be forgotten and not used for this request.";
            LOGGER.warn(message);
        }
        this.forgetIdentity(context);
        throw e;
    }

    protected byte[] encrypt(byte[] serialized) {
        byte[] value = serialized;
        CipherService cipherService = this.getCipherService();
        if (cipherService != null) {
            ByteSource byteSource = cipherService.encrypt(serialized, this.getEncryptionCipherKey());
            value = byteSource.getBytes();
        }
        return value;
    }

    protected byte[] decrypt(byte[] encrypted) {
        byte[] serialized = encrypted;
        CipherService cipherService = this.getCipherService();
        if (cipherService != null) {
            ByteSourceBroker broker = cipherService.decrypt(encrypted, this.getDecryptionCipherKey());
            serialized = broker.getClonedBytes();
        }
        return serialized;
    }

    protected byte[] serialize(PrincipalCollection principals) {
        return this.getSerializer().serialize((Object)principals);
    }

    protected PrincipalCollection deserialize(byte[] serializedIdentity) {
        return (PrincipalCollection)this.getSerializer().deserialize(serializedIdentity);
    }

    @Override
    public void onFailedLogin(Subject subject, AuthenticationToken token, AuthenticationException ae) {
        this.forgetIdentity(subject);
    }

    @Override
    public void onLogout(Subject subject) {
        this.forgetIdentity(subject);
    }
}

