/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import org.apache.shiro.util.AntPathMatcher;
import org.junit.Assert;
import org.junit.Test;

public class AntPathMatcherTests {
    private final AntPathMatcher pathMatcher = new AntPathMatcher();

    @Test
    public void match() {
        Assert.assertTrue((boolean)this.pathMatcher.match("test", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/test", "/test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("https://example.org", "https://example.org"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/test.jpg", "test.jpg"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test", "/test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/test", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("t?st", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("??st", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("tes?", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("te??", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("?es?", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("tes?", "tes"));
        Assert.assertFalse((boolean)this.pathMatcher.match("tes?", "testt"));
        Assert.assertFalse((boolean)this.pathMatcher.match("tes?", "tsst"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test*", "testTest"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test/*", "test/Test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test/*", "test/t"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test/*", "test/"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*test*", "AnothertestTest"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*test", "Anothertest"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*.*", "test."));
        Assert.assertTrue((boolean)this.pathMatcher.match("*.*", "test.test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*.*", "test.test.test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test*aaa", "testblaaaa"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*", "tst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*", "tsttest"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*", "test/"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*", "test/t"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test/*", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*test*", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*test", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*.*", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*aaa", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*aaa", "testblaaab"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/?", "/a"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/?/a", "/a/a"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/a/?", "/a/b"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/??/a", "/aa/a"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/a/??", "/a/bb"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/?", "/a"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/**", "/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/*/**", "/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/**/*", "/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/bla/**/bla", "/bla/testing/testing/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/bla/**/bla", "/bla/testing/testing/bla/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/**/test", "/bla/bla/test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/bla/**/**/bla", "/bla/bla/bla/bla/bla/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/bla*bla/test", "/blaXXXbla/test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/*bla/test", "/XXXbla/test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/bla*bla/test", "/blaXXXbl/test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/*bla/test", "XXXblab/test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/*bla/test", "XXXbl/test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/????", "/bala/bla"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/**/*bla", "/bla/bla/bla/bbb"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/*bla*/**/bla/**", "/XXXblaXXXX/testing/testing/bla/testing/testing/"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/*bla*/**/bla/*", "/XXXblaXXXX/testing/testing/bla/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/*bla*/**/bla/**", "/XXXblaXXXX/testing/testing/bla/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/*bla*/**/bla/**", "/XXXblaXXXX/testing/testing/bla/testing/testing.jpg"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*bla*/**/bla/**", "XXXblaXXXX/testing/testing/bla/testing/testing/"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*bla*/**/bla/*", "XXXblaXXXX/testing/testing/bla/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*bla*/**/bla/**", "XXXblaXXXX/testing/testing/bla/testing/testing"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*bla*/**/bla/*", "XXXblaXXXX/testing/testing/bla/testing/testing"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/x/x/**/bla", "/x/x/x/"));
        Assert.assertTrue((boolean)this.pathMatcher.match("/foo/bar/**", "/foo/bar"));
        Assert.assertTrue((boolean)this.pathMatcher.match("", ""));
    }

    @Test
    public void matchWithNullPath() {
        Assert.assertFalse((boolean)this.pathMatcher.match("/test", null));
        Assert.assertFalse((boolean)this.pathMatcher.match("/", null));
        Assert.assertFalse((boolean)this.pathMatcher.match(null, null));
    }

    @Test
    public void matchStart() {
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/test", "/test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("/test.jpg", "test.jpg"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test", "/test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("/test", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("t?st", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("??st", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("tes?", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("te??", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("?es?", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("tes?", "tes"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("tes?", "testt"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("tes?", "tsst"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test*", "testTest"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test/*", "test/Test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test/*", "test/t"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test/*", "test/"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*test*", "AnothertestTest"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*test", "Anothertest"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*.*", "test."));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*.*", "test.test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*.*", "test.test.test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test*aaa", "testblaaaa"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*", "tst"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*", "test/"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*", "tsttest"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*", "test/"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*", "test/t"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test/*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test/t*.txt", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("*test*", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("*test", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("*.*", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*aaa", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("test*aaa", "testblaaab"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/?", "/a"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/?/a", "/a/a"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/a/?", "/a/b"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/??/a", "/aa/a"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/a/??", "/a/bb"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/?", "/a"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/**", "/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/*/**", "/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/**/*", "/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test*/**", "test/"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("test*/**", "test/t"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/bla/**/bla", "/bla/testing/testing/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/bla/**/bla", "/bla/testing/testing/bla/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/**/test", "/bla/bla/test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/bla/**/**/bla", "/bla/bla/bla/bla/bla/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/bla*bla/test", "/blaXXXbla/test"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/*bla/test", "/XXXbla/test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("/bla*bla/test", "/blaXXXbl/test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("/*bla/test", "XXXblab/test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("/*bla/test", "XXXbl/test"));
        Assert.assertFalse((boolean)this.pathMatcher.matchStart("/????", "/bala/bla"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/**/*bla", "/bla/bla/bla/bbb"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/*bla*/**/bla/**", "/XXXblaXXXX/testing/testing/bla/testing/testing/"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/*bla*/**/bla/*", "/XXXblaXXXX/testing/testing/bla/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/*bla*/**/bla/**", "/XXXblaXXXX/testing/testing/bla/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/*bla*/**/bla/**", "/XXXblaXXXX/testing/testing/bla/testing/testing.jpg"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*bla*/**/bla/**", "XXXblaXXXX/testing/testing/bla/testing/testing/"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*bla*/**/bla/*", "XXXblaXXXX/testing/testing/bla/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*bla*/**/bla/**", "XXXblaXXXX/testing/testing/bla/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("*bla*/**/bla/*", "XXXblaXXXX/testing/testing/bla/testing/testing"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("/x/x/**/bla", "/x/x/x/"));
        Assert.assertTrue((boolean)this.pathMatcher.matchStart("", ""));
    }

    @Test
    public void uniqueDeliminator() {
        this.pathMatcher.setPathSeparator(".");
        Assert.assertTrue((boolean)this.pathMatcher.match("test", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".test", ".test"));
        Assert.assertFalse((boolean)this.pathMatcher.match(".test/jpg", "test/jpg"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test", ".test"));
        Assert.assertFalse((boolean)this.pathMatcher.match(".test", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("t?st", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("??st", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("tes?", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("te??", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("?es?", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("tes?", "tes"));
        Assert.assertFalse((boolean)this.pathMatcher.match("tes?", "testt"));
        Assert.assertFalse((boolean)this.pathMatcher.match("tes?", "tsst"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test*", "test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test*", "testTest"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*test*", "AnothertestTest"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*test", "Anothertest"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*/*", "test/"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*/*", "test/test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("*/*", "test/test/test"));
        Assert.assertTrue((boolean)this.pathMatcher.match("test*aaa", "testblaaaa"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*", "tst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*", "tsttest"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*test*", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*test", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("*/*", "tsttst"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*aaa", "test"));
        Assert.assertFalse((boolean)this.pathMatcher.match("test*aaa", "testblaaab"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".?", ".a"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".?.a", ".a.a"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".a.?", ".a.b"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".??.a", ".aa.a"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".a.??", ".a.bb"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".?", ".a"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".**", ".testing.testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".*.**", ".testing.testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".**.*", ".testing.testing"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".bla.**.bla", ".bla.testing.testing.bla"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".bla.**.bla", ".bla.testing.testing.bla.bla"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".**.test", ".bla.bla.test"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".bla.**.**.bla", ".bla.bla.bla.bla.bla.bla"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".bla*bla.test", ".blaXXXbla.test"));
        Assert.assertTrue((boolean)this.pathMatcher.match(".*bla.test", ".XXXbla.test"));
        Assert.assertFalse((boolean)this.pathMatcher.match(".bla*bla.test", ".blaXXXbl.test"));
        Assert.assertFalse((boolean)this.pathMatcher.match(".*bla.test", "XXXblab.test"));
        Assert.assertFalse((boolean)this.pathMatcher.match(".*bla.test", "XXXbl.test"));
    }

    @Test
    public void extractPathWithinPattern() throws Exception {
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/commit.html", "/docs/commit.html"), (Object)"");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/*", "/docs/cvs/commit"), (Object)"cvs/commit");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/cvs/*.html", "/docs/cvs/commit.html"), (Object)"commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/**", "/docs/cvs/commit"), (Object)"cvs/commit");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/**/*.html", "/docs/cvs/commit.html"), (Object)"cvs/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/**/*.html", "/docs/commit.html"), (Object)"commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/*.html", "/commit.html"), (Object)"commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/*.html", "/docs/commit.html"), (Object)"docs/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("*.html", "/commit.html"), (Object)"/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("*.html", "/docs/commit.html"), (Object)"/docs/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("**/*.*", "/docs/commit.html"), (Object)"/docs/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("*", "/docs/commit.html"), (Object)"/docs/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("**/commit.html", "/docs/cvs/other/commit.html"), (Object)"/docs/cvs/other/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/**/commit.html", "/docs/cvs/other/commit.html"), (Object)"cvs/other/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/**/**/**/**", "/docs/cvs/other/commit.html"), (Object)"cvs/other/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/d?cs/*", "/docs/cvs/commit"), (Object)"docs/cvs/commit");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/docs/c?s/*.html", "/docs/cvs/commit.html"), (Object)"cvs/commit.html");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/d?cs/**", "/docs/cvs/commit"), (Object)"docs/cvs/commit");
        Assert.assertEquals((Object)this.pathMatcher.extractPathWithinPattern("/d?cs/**/*.html", "/docs/cvs/commit.html"), (Object)"docs/cvs/commit.html");
    }

    @Test
    public void spaceInTokens() {
        Assert.assertTrue((boolean)this.pathMatcher.match("/group/sales/members", "/group/sales/members"));
        Assert.assertFalse((boolean)this.pathMatcher.match("/group/sales/members", "/Group/  sales/Members"));
    }

    @Test
    public void isPattern() {
        Assert.assertTrue((boolean)this.pathMatcher.isPattern("/test/*"));
        Assert.assertTrue((boolean)this.pathMatcher.isPattern("/test/**/name"));
        Assert.assertTrue((boolean)this.pathMatcher.isPattern("/test?"));
        Assert.assertFalse((boolean)this.pathMatcher.isPattern("/test/{name}"));
        Assert.assertFalse((boolean)this.pathMatcher.isPattern("/test/name"));
        Assert.assertFalse((boolean)this.pathMatcher.isPattern("/test/foo{bar"));
    }

    @Test
    public void matches() {
        Assert.assertTrue((boolean)this.pathMatcher.matches("/foo/*", "/foo/"));
    }

    @Test
    public void isPatternWithNullPath() {
        Assert.assertFalse((boolean)this.pathMatcher.isPattern(null));
    }
}

