/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.ThreadContext;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingSubjectTest {
    @Before
    public void setup() {
        ThreadContext.remove();
    }

    @After
    public void tearDown() {
        ThreadContext.remove();
    }

    @Test
    public void testSessionStopThenStart() {
        String key = "testKey";
        String value = "testValue";
        DefaultSecurityManager sm = new DefaultSecurityManager();
        DelegatingSubject subject = new DelegatingSubject((SecurityManager)sm);
        Session session = subject.getSession();
        session.setAttribute((Object)key, (Object)value);
        Assert.assertTrue((boolean)session.getAttribute((Object)key).equals(value));
        Serializable firstSessionId = session.getId();
        Assert.assertNotNull((Object)firstSessionId);
        session.stop();
        session = subject.getSession();
        Assert.assertNotNull((Object)session);
        Assert.assertNull((Object)session.getAttribute((Object)key));
        Serializable secondSessionId = session.getId();
        Assert.assertNotNull((Object)secondSessionId);
        Assert.assertFalse((boolean)firstSessionId.equals(secondSessionId));
        subject.logout();
        sm.destroy();
    }

    @Test
    public void testExecuteCallable() {
        String username = "jsmith";
        SecurityManager securityManager = (SecurityManager)EasyMock.createNiceMock(SecurityManager.class);
        SimplePrincipalCollection identity = new SimplePrincipalCollection((Object)username, "testRealm");
        DelegatingSubject sourceSubject = new DelegatingSubject((PrincipalCollection)identity, true, null, null, securityManager);
        Assert.assertNull((Object)ThreadContext.getSubject());
        Assert.assertNull((Object)ThreadContext.getSecurityManager());
        Callable<String> callable = new Callable<String>((Subject)sourceSubject){
            final /* synthetic */ Subject val$sourceSubject;
            {
                this.val$sourceSubject = subject;
            }

            @Override
            public String call() throws Exception {
                Subject callingSubject = SecurityUtils.getSubject();
                Assert.assertNotNull((Object)callingSubject);
                Assert.assertNotNull((Object)SecurityUtils.getSecurityManager());
                Assert.assertEquals((Object)callingSubject, (Object)this.val$sourceSubject);
                return "Hello " + callingSubject.getPrincipal();
            }
        };
        String response = (String)sourceSubject.execute((Callable)callable);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)("Hello " + username), (Object)response);
        Assert.assertNull((Object)ThreadContext.getSubject());
        Assert.assertNull((Object)ThreadContext.getSecurityManager());
    }

    @Test
    public void testExecuteRunnable() {
        String username = "jsmith";
        SecurityManager securityManager = (SecurityManager)EasyMock.createNiceMock(SecurityManager.class);
        SimplePrincipalCollection identity = new SimplePrincipalCollection((Object)username, "testRealm");
        DelegatingSubject sourceSubject = new DelegatingSubject((PrincipalCollection)identity, true, null, null, securityManager);
        Assert.assertNull((Object)ThreadContext.getSubject());
        Assert.assertNull((Object)ThreadContext.getSecurityManager());
        Runnable runnable = new Runnable((Subject)sourceSubject){
            final /* synthetic */ Subject val$sourceSubject;
            {
                this.val$sourceSubject = subject;
            }

            @Override
            public void run() {
                Subject callingSubject = SecurityUtils.getSubject();
                Assert.assertNotNull((Object)callingSubject);
                Assert.assertNotNull((Object)SecurityUtils.getSecurityManager());
                Assert.assertEquals((Object)callingSubject, (Object)this.val$sourceSubject);
            }
        };
        sourceSubject.execute(runnable);
        Assert.assertNull((Object)ThreadContext.getSubject());
        Assert.assertNull((Object)ThreadContext.getSecurityManager());
    }

    @Test
    public void testRunAs() {
        Ini ini = new Ini();
        Ini.Section users = ini.addSection("users");
        users.put("user1", "user1,role1");
        users.put("user2", "user2,role2");
        users.put("user3", "user3,role3");
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory(ini);
        SecurityManager sm = (SecurityManager)factory.getInstance();
        Subject subject = new Subject.Builder(sm).buildSubject();
        subject.login((AuthenticationToken)new UsernamePasswordToken("user1", "user1"));
        Assert.assertFalse((boolean)subject.isRunAs());
        Assert.assertEquals((Object)"user1", (Object)subject.getPrincipal());
        Assert.assertTrue((boolean)subject.hasRole("role1"));
        Assert.assertFalse((boolean)subject.hasRole("role2"));
        Assert.assertFalse((boolean)subject.hasRole("role3"));
        Assert.assertNull((Object)subject.getPreviousPrincipals());
        subject.runAs((PrincipalCollection)new SimplePrincipalCollection((Object)"user2", "iniRealm"));
        Assert.assertTrue((boolean)subject.isRunAs());
        Assert.assertEquals((Object)"user2", (Object)subject.getPrincipal());
        Assert.assertTrue((boolean)subject.hasRole("role2"));
        Assert.assertFalse((boolean)subject.hasRole("role1"));
        Assert.assertFalse((boolean)subject.hasRole("role3"));
        PrincipalCollection previous = subject.getPreviousPrincipals();
        Assert.assertFalse((previous == null || previous.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)previous.getPrimaryPrincipal().equals("user1"));
        subject.runAs((PrincipalCollection)new SimplePrincipalCollection((Object)"user3", "iniRealm"));
        Assert.assertTrue((boolean)subject.isRunAs());
        Assert.assertEquals((Object)"user3", (Object)subject.getPrincipal());
        Assert.assertTrue((boolean)subject.hasRole("role3"));
        Assert.assertFalse((boolean)subject.hasRole("role1"));
        Assert.assertFalse((boolean)subject.hasRole("role2"));
        previous = subject.getPreviousPrincipals();
        Assert.assertFalse((previous == null || previous.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)previous.getPrimaryPrincipal().equals("user2"));
        subject.releaseRunAs();
        Assert.assertTrue((boolean)subject.isRunAs());
        Assert.assertEquals((Object)"user2", (Object)subject.getPrincipal());
        Assert.assertTrue((boolean)subject.hasRole("role2"));
        Assert.assertFalse((boolean)subject.hasRole("role1"));
        Assert.assertFalse((boolean)subject.hasRole("role3"));
        previous = subject.getPreviousPrincipals();
        Assert.assertFalse((previous == null || previous.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)previous.getPrimaryPrincipal().equals("user1"));
        subject.releaseRunAs();
        Assert.assertFalse((boolean)subject.isRunAs());
        Assert.assertEquals((Object)"user1", (Object)subject.getPrincipal());
        Assert.assertTrue((boolean)subject.hasRole("role1"));
        Assert.assertFalse((boolean)subject.hasRole("role2"));
        Assert.assertFalse((boolean)subject.hasRole("role3"));
        Assert.assertNull((Object)subject.getPreviousPrincipals());
        subject.logout();
        LifecycleUtils.destroy((Object)sm);
    }
}

