/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import org.apache.shiro.session.mgt.SimpleSession;
import org.junit.Assert;
import org.junit.Test;

public class SimpleSessionTest {
    @Test
    public void testDefaultSerialization() throws Exception {
        SimpleSession session = new SimpleSession();
        long timeout = session.getTimeout();
        Date start = session.getStartTimestamp();
        Date lastAccess = session.getLastAccessTime();
        SimpleSession deserialized = this.serializeAndDeserialize(session);
        Assert.assertEquals((long)timeout, (long)deserialized.getTimeout());
        Assert.assertEquals((Object)start, (Object)deserialized.getStartTimestamp());
        Assert.assertEquals((Object)lastAccess, (Object)deserialized.getLastAccessTime());
    }

    @Test
    public void serializeHost() throws IOException, ClassNotFoundException {
        SimpleSession session = new SimpleSession("localhost");
        Assert.assertEquals((Object)"localhost", (Object)this.serializeAndDeserialize(session).getHost());
    }

    @Test
    public void serializeExpired() throws IOException, ClassNotFoundException {
        SimpleSession session = new SimpleSession();
        session.setExpired(true);
        Assert.assertTrue((boolean)this.serializeAndDeserialize(session).isExpired());
    }

    private SimpleSession serializeAndDeserialize(SimpleSession session) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream serialized = new ByteArrayOutputStream();
        ObjectOutputStream serializer = new ObjectOutputStream(serialized);
        serializer.writeObject(session);
        serializer.close();
        return (SimpleSession)new ObjectInputStream(new ByteArrayInputStream(serialized.toByteArray())).readObject();
    }
}

