/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.ExecutorServiceSessionValidationScheduler;
import org.apache.shiro.session.mgt.SimpleSession;
import org.apache.shiro.session.mgt.ValidatingSessionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExecutorServiceSessionValidationSchedulerTest {
    ExecutorServiceSessionValidationScheduler executorServiceSessionValidationScheduler;
    DefaultSessionManager defaultSessionManager;

    @Before
    public void setUp() {
        this.defaultSessionManager = new DefaultSessionManager();
        this.defaultSessionManager.setDeleteInvalidSessions(true);
        this.executorServiceSessionValidationScheduler = new ExecutorServiceSessionValidationScheduler();
        this.executorServiceSessionValidationScheduler.setSessionManager((ValidatingSessionManager)this.defaultSessionManager);
        this.executorServiceSessionValidationScheduler.setThreadNamePrefix("test-");
        this.executorServiceSessionValidationScheduler.setInterval(1000L);
        this.executorServiceSessionValidationScheduler.enableSessionValidation();
    }

    @Test
    public void timeoutSessionValidate() throws InterruptedException {
        SimpleSession session = new SimpleSession();
        session.setTimeout(2000L);
        this.defaultSessionManager.create((Session)session);
        Thread.sleep(5000L);
        Assert.assertTrue((boolean)this.defaultSessionManager.getActiveSessions().isEmpty());
        Assert.assertTrue((boolean)this.executorServiceSessionValidationScheduler.isEnabled());
    }

    @Test
    public void stopSessionValidate() throws InterruptedException {
        SimpleSession session = new SimpleSession();
        session.setTimeout(10000L);
        this.defaultSessionManager.create((Session)session);
        Thread.sleep(1000L);
        session.stop();
        Thread.sleep(3000L);
        Assert.assertTrue((boolean)this.defaultSessionManager.getActiveSessions().isEmpty());
        Assert.assertTrue((boolean)this.executorServiceSessionValidationScheduler.isEnabled());
    }

    @Test
    public void enableSessionValidation() throws InterruptedException {
        Assert.assertTrue((boolean)this.executorServiceSessionValidationScheduler.isEnabled());
        this.executorServiceSessionValidationScheduler.disableSessionValidation();
        Thread.sleep(2000L);
        Assert.assertFalse((boolean)this.executorServiceSessionValidationScheduler.isEnabled());
        this.executorServiceSessionValidationScheduler.enableSessionValidation();
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)this.executorServiceSessionValidationScheduler.isEnabled());
    }

    @Test
    public void threadException() throws InterruptedException {
        SimpleSession session = new SimpleSession();
        this.defaultSessionManager = new FakeDefaultSessionManager();
        this.defaultSessionManager.setDeleteInvalidSessions(true);
        this.executorServiceSessionValidationScheduler = new ExecutorServiceSessionValidationScheduler();
        this.executorServiceSessionValidationScheduler.setSessionManager((ValidatingSessionManager)this.defaultSessionManager);
        this.executorServiceSessionValidationScheduler.setThreadNamePrefix("test-");
        this.executorServiceSessionValidationScheduler.setInterval(1000L);
        this.executorServiceSessionValidationScheduler.enableSessionValidation();
        this.defaultSessionManager.create((Session)session);
        Thread.sleep(2000L);
        session.stop();
        Thread.sleep(2000L);
        Assert.assertFalse((boolean)this.defaultSessionManager.getActiveSessions().isEmpty());
        Assert.assertTrue((boolean)this.executorServiceSessionValidationScheduler.isEnabled());
    }

    @After
    public void tearDown() throws Exception {
        this.executorServiceSessionValidationScheduler.disableSessionValidation();
    }

    private class FakeDefaultSessionManager
    extends DefaultSessionManager {
        private FakeDefaultSessionManager() {
        }

        public void validateSessions() throws RuntimeException {
            throw new RuntimeException("Session test exception");
        }
    }
}

