/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.text;

import java.text.ParseException;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.realm.text.TextConfigurationRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.junit.Assert;
import org.junit.Test;

public class TextConfigurationRealmTest {
    private TestRealm realm;

    private void setRoles() {
        StringBuilder roleDefinitions = new StringBuilder().append("role1 = role1_permission1\n").append("role2 = role2_persission1, role2_permission2\n");
        this.realm.setRoleDefinitions(roleDefinitions.toString());
    }

    private void setUsers() {
        StringBuilder userDefinitions = new StringBuilder();
        for (int i = 1; i < 3; ++i) {
            userDefinitions.append(String.format("user%1$d = user%1$d_password, role1, role2%n", i));
        }
        this.realm.setUserDefinitions(userDefinitions.toString());
    }

    private void setUpForReadConfigurationTest() {
        this.realm = new TestRealm(){

            @Override
            public void test(Thread runnable) throws InterruptedException {
                this.USERS_LOCK.writeLock().lock();
                try {
                    this.ROLES_LOCK.writeLock().lock();
                    try {
                        runnable.start();
                        Thread.sleep(500L);
                        TextConfigurationRealmTest.this.realm.onInit();
                    }
                    finally {
                        this.ROLES_LOCK.writeLock().unlock();
                    }
                }
                finally {
                    this.USERS_LOCK.writeLock().unlock();
                }
            }
        };
        this.setRoles();
        this.setUsers();
    }

    private void executeTest(Runnable runnable) throws InterruptedException {
        TestThread testThread = new TestThread(runnable);
        Thread testTask = new Thread(testThread);
        this.realm.test(testTask);
        testTask.join(500L);
        testThread.test();
    }

    @Test
    public void testRoleAndUserAccount() throws InterruptedException {
        this.setUpForReadConfigurationTest();
        this.executeTest(new Runnable(){

            @Override
            public void run() {
                Assert.assertTrue((String)"role not found when it was expected", (boolean)TextConfigurationRealmTest.this.realm.roleExists("role1"));
                Assert.assertTrue((String)"user not found when it was expected", (boolean)TextConfigurationRealmTest.this.realm.accountExists("user1"));
            }
        });
    }

    @Test
    public void testHasRole() throws InterruptedException {
        this.setUpForReadConfigurationTest();
        this.executeTest(new Runnable(){

            @Override
            public void run() {
                SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)"user1", "realm1");
                Assert.assertTrue((String)"principal doesn't have role when it should", (boolean)TextConfigurationRealmTest.this.realm.hasRole((PrincipalCollection)principalCollection, "role2"));
                Assert.assertTrue((String)"principal doesn't have all roles when it should", (boolean)TextConfigurationRealmTest.this.realm.hasAllRoles((PrincipalCollection)principalCollection, Arrays.asList("role1", "role2")));
            }
        });
    }

    @Test
    public void testCheckRole() throws InterruptedException {
        this.setUpForReadConfigurationTest();
        this.executeTest(new Runnable(){

            @Override
            public void run() {
                SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)"user1", "realm1");
                try {
                    TextConfigurationRealmTest.this.realm.checkRoles((PrincipalCollection)principalCollection, new String[]{"role1", "role2"});
                }
                catch (AuthorizationException ae) {
                    Assert.fail((String)"principal doesn't have all roles when it should");
                }
            }
        });
    }

    @Test
    public void testCheckPermission() throws InterruptedException {
        this.setUpForReadConfigurationTest();
        this.executeTest(new Runnable(){

            @Override
            public void run() {
                SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)"user1", "realm1");
                try {
                    TextConfigurationRealmTest.this.realm.checkPermission((PrincipalCollection)principalCollection, "role1_permission1");
                    TextConfigurationRealmTest.this.realm.checkPermissions((PrincipalCollection)principalCollection, new String[]{"role1_permission1", "role2_permission2"});
                }
                catch (AuthorizationException ae) {
                    Assert.fail((String)"principal doesn't have permission when it should");
                }
            }
        });
    }

    @Test
    public void testIsPermitted() throws InterruptedException {
        this.setUpForReadConfigurationTest();
        this.executeTest(new Runnable(){

            @Override
            public void run() {
                SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)"user1", "realm1");
                Assert.assertTrue((String)"permission not permitted when it should be", (boolean)TextConfigurationRealmTest.this.realm.isPermitted((PrincipalCollection)principalCollection, "role1_permission1"));
                Assert.assertTrue((String)"permission not permitted when it should be", (boolean)TextConfigurationRealmTest.this.realm.isPermittedAll((PrincipalCollection)principalCollection, new String[]{"role1_permission1", "role2_permission2"}));
            }
        });
    }

    @Test
    public void testProcessRoleDefinitions() throws InterruptedException {
        this.realm = new TestRealm(){

            @Override
            public void test(Thread runnable) throws InterruptedException {
                this.ROLES_LOCK.writeLock().lock();
                try {
                    runnable.start();
                    Thread.sleep(500L);
                    Assert.assertFalse((String)"role exists when it shouldn't", (boolean)TextConfigurationRealmTest.this.realm.roleExists("role1"));
                }
                finally {
                    this.ROLES_LOCK.writeLock().unlock();
                }
            }
        };
        TestThread testThread = new TestThread(new Runnable(){

            @Override
            public void run() {
                try {
                    TextConfigurationRealmTest.this.realm.processRoleDefinitions();
                }
                catch (ParseException e) {
                    Assert.fail((String)"Unable to parse role definitions");
                }
            }
        });
        this.setRoles();
        Thread testTask = new Thread(testThread);
        this.realm.test(testTask);
        testTask.join(500L);
        Assert.assertTrue((String)"role doesn't exist when it should", (boolean)this.realm.roleExists("role1"));
        testThread.test();
    }

    @Test
    public void testProcessUserDefinitions() throws InterruptedException {
        this.realm = new TestRealm(){

            @Override
            public void test(Thread runnable) throws InterruptedException {
                this.USERS_LOCK.writeLock().lock();
                try {
                    runnable.start();
                    Thread.sleep(500L);
                    Assert.assertFalse((String)"account exists when it shouldn't", (boolean)TextConfigurationRealmTest.this.realm.accountExists("user1"));
                }
                finally {
                    this.USERS_LOCK.writeLock().unlock();
                }
            }
        };
        TestThread testThread = new TestThread(new Runnable(){

            @Override
            public void run() {
                try {
                    TextConfigurationRealmTest.this.realm.processUserDefinitions();
                }
                catch (ParseException e) {
                    Assert.fail((String)"Unable to parse user definitions");
                }
            }
        });
        this.setUsers();
        Thread testTask = new Thread(testThread);
        this.realm.test(testTask);
        testTask.join(500L);
        Assert.assertTrue((String)"account doesn't exist when it should", (boolean)this.realm.accountExists("user1"));
        testThread.test();
    }

    private abstract class TestRealm
    extends TextConfigurationRealm {
        private TestRealm() {
        }

        public abstract void test(Thread var1) throws InterruptedException;
    }

    private class TestThread
    implements Runnable {
        private Runnable test;
        private volatile AssertionError ae;

        public TestThread(Runnable test) {
            this.test = test;
        }

        @Override
        public void run() {
            try {
                this.test.run();
            }
            catch (AssertionError ae) {
                this.ae = ae;
            }
        }

        public void test() {
            if (this.ae != null) {
                throw this.ae;
            }
        }
    }
}

