/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.activedirectory;

import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.UserIdPrincipal;
import org.apache.shiro.realm.UsernamePrincipal;
import org.apache.shiro.realm.activedirectory.ActiveDirectoryRealm;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ActiveDirectoryRealmTest {
    DefaultSecurityManager securityManager = null;
    AuthorizingRealm realm;
    private static final String USERNAME = "testuser";
    private static final String PASSWORD = "password";
    private static final int USER_ID = 12345;
    private static final String ROLE = "admin";

    @Before
    public void setup() {
        ThreadContext.remove();
        this.realm = new TestActiveDirectoryRealm();
        this.securityManager = new DefaultSecurityManager((Realm)this.realm);
        SecurityUtils.setSecurityManager((SecurityManager)this.securityManager);
    }

    @After
    public void tearDown() {
        SecurityUtils.setSecurityManager(null);
        this.securityManager.destroy();
        ThreadContext.remove();
    }

    @Test
    public void testDefaultConfig() {
        String localhost = "localhost";
        Subject subject = SecurityUtils.getSubject();
        subject.login((AuthenticationToken)new UsernamePasswordToken(USERNAME, PASSWORD, localhost));
        Assert.assertTrue((boolean)subject.isAuthenticated());
        Assert.assertTrue((boolean)subject.hasRole(ROLE));
        UsernamePrincipal usernamePrincipal = (UsernamePrincipal)subject.getPrincipals().oneByType(UsernamePrincipal.class);
        Assert.assertTrue((boolean)usernamePrincipal.getUsername().equals(USERNAME));
        UserIdPrincipal userIdPrincipal = (UserIdPrincipal)subject.getPrincipals().oneByType(UserIdPrincipal.class);
        Assert.assertTrue((userIdPrincipal.getUserId() == 12345 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.realm.hasRole(subject.getPrincipals(), ROLE));
        subject.logout();
    }

    @Test
    public void testExistingUserSuffix() throws Exception {
        this.assertExistingUserSuffix(USERNAME, "testuser@ExAmple.COM");
        this.assertExistingUserSuffix("testuser@example.com", "testuser@example.com");
        this.assertExistingUserSuffix("testuser@EXAMPLE.com", "testuser@EXAMPLE.com");
    }

    public void assertExistingUserSuffix(String username, String expectedPrincipalName) throws Exception {
        LdapContext ldapContext = (LdapContext)EasyMock.createMock(LdapContext.class);
        NamingEnumeration results = (NamingEnumeration)EasyMock.createMock(NamingEnumeration.class);
        Capture captureArgs = Capture.newInstance((CaptureType)CaptureType.ALL);
        EasyMock.expect(ldapContext.search(EasyMock.anyString(), EasyMock.anyString(), (Object[])EasyMock.capture((Capture)captureArgs), (SearchControls)EasyMock.anyObject(SearchControls.class))).andReturn((Object)results);
        EasyMock.replay((Object[])new Object[]{ldapContext});
        ActiveDirectoryRealm activeDirectoryRealm = new ActiveDirectoryRealm(){
            {
                this.principalSuffix = "@ExAmple.COM";
            }
        };
        DefaultSecurityManager securityManager = new DefaultSecurityManager((Realm)activeDirectoryRealm);
        Subject subject = new Subject.Builder((SecurityManager)securityManager).buildSubject();
        subject.execute(() -> {
            try {
                activeDirectoryRealm.getRoleNamesForUser(username, ldapContext);
            }
            catch (NamingException e) {
                Assert.fail((String)"Unexpected NamingException thrown during test");
            }
        });
        Object[] args = (Object[])captureArgs.getValue();
        MatcherAssert.assertThat((Object)args, (Matcher)Matchers.arrayWithSize((int)1));
        MatcherAssert.assertThat((Object)args[0], (Matcher)Matchers.is((Object)expectedPrincipalName));
    }

    public class TestActiveDirectoryRealm
    extends ActiveDirectoryRealm {
        CredentialsMatcher credentialsMatcher;

        public TestActiveDirectoryRealm() {
            this.credentialsMatcher = new CredentialsMatcher(){

                public boolean doCredentialsMatch(AuthenticationToken object, AuthenticationInfo object1) {
                    return true;
                }
            };
            this.setCredentialsMatcher(this.credentialsMatcher);
        }

        public void setPrincipalSuffix(String principalSuffix) {
            this.principalSuffix = principalSuffix;
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
            SimpleAccount account = (SimpleAccount)super.doGetAuthenticationInfo(token);
            if (account != null) {
                SimplePrincipalCollection principals = new SimplePrincipalCollection();
                principals.add((Object)new UserIdPrincipal(12345), this.getName());
                principals.add((Object)new UsernamePrincipal(ActiveDirectoryRealmTest.USERNAME), this.getName());
                account.setPrincipals((PrincipalCollection)principals);
            }
            return account;
        }

        protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
            HashSet<String> roles = new HashSet<String>();
            roles.add(ActiveDirectoryRealmTest.ROLE);
            return new SimpleAuthorizationInfo(roles);
        }

        protected AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken token, LdapContextFactory ldapContextFactory) throws NamingException {
            return new SimpleAccount(token.getPrincipal(), token.getCredentials(), this.getName());
        }
    }
}

