/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.apache.shiro.subject.support.DelegatingSubject;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DefaultSubjectDAOTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DefaultSubjectDAOTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testIsSessionStorageEnabledDefault() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[0].callConstructor(DefaultSubjectDAO.class);
        callSiteArray[1].callStatic(Assert.class, (Object)(callSiteArray[2].callGetProperty(dao) instanceof DefaultSessionStorageEvaluator));
        callSiteArray[3].callStatic(Assert.class, callSiteArray[4].call(dao, null));
    }

    @Test
    public void testIsSessionStorageEnabledDefaultSubject() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[5].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[6].callStatic(EasyMock.class, Subject.class);
        callSiteArray[7].call(callSiteArray[8].callStatic(EasyMock.class, callSiteArray[9].call(subject, (Object)false)), null);
        callSiteArray[10].callStatic(EasyMock.class, subject);
        callSiteArray[11].callStatic(Assert.class, callSiteArray[12].call(dao, subject));
        callSiteArray[13].callStatic(EasyMock.class, subject);
    }

    @Test
    public void testCustomSessionStorageEvaluator() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[14].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[15].callStatic(EasyMock.class, Subject.class);
        Object evaluator = callSiteArray[16].callStatic(EasyMock.class, SessionStorageEvaluator.class);
        Object object = evaluator;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)dao, (String)"sessionStorageEvaluator");
        callSiteArray[17].call(callSiteArray[18].callStatic(EasyMock.class, callSiteArray[19].call(evaluator, callSiteArray[20].callStatic(EasyMock.class, subject))), (Object)true);
        callSiteArray[21].callStatic(EasyMock.class, subject, evaluator);
        callSiteArray[22].callStatic(Assert.class, callSiteArray[23].call(dao, subject));
        callSiteArray[24].callStatic(EasyMock.class, subject, evaluator);
    }

    @Test
    public void testDeleteWithoutSession() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[25].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[26].callStatic(EasyMock.class, Subject.class);
        callSiteArray[27].call(callSiteArray[28].callStatic(EasyMock.class, callSiteArray[29].call(subject, (Object)false)), null);
        callSiteArray[30].callStatic(EasyMock.class, subject);
        callSiteArray[31].call(dao, subject);
        callSiteArray[32].callStatic(EasyMock.class, subject);
    }

    @Test
    public void testDeleteWithSession() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[33].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[34].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[35].callStatic(EasyMock.class, Session.class);
        callSiteArray[36].call(callSiteArray[37].callStatic(EasyMock.class, callSiteArray[38].call(subject, (Object)false)), session);
        callSiteArray[39].call(callSiteArray[40].callStatic(EasyMock.class, callSiteArray[41].call(session, callSiteArray[42].callStatic(EasyMock.class, callSiteArray[43].callGetProperty(DefaultSubjectContext.class)))), null);
        callSiteArray[44].call(callSiteArray[45].callStatic(EasyMock.class, callSiteArray[46].call(session, callSiteArray[47].callStatic(EasyMock.class, callSiteArray[48].callGetProperty(DefaultSubjectContext.class)))), null);
        callSiteArray[49].callStatic(EasyMock.class, subject, session);
        callSiteArray[50].call(dao, subject);
        callSiteArray[51].callStatic(EasyMock.class, subject, session);
    }

    @Test
    public void testSaveWhenSessionStorageIsDisabled() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[52].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[53].callStatic(EasyMock.class, Subject.class);
        callSiteArray[54].call(callSiteArray[55].callStatic(EasyMock.class, callSiteArray[56].call(subject, (Object)false)), null);
        boolean bl = false;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)((DefaultSessionStorageEvaluator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[57].callGetProperty(dao), DefaultSessionStorageEvaluator.class)), (String)"sessionStorageEnabled");
        callSiteArray[58].callStatic(EasyMock.class, subject);
        Subject saved = (Subject)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].call(dao, subject), Subject.class);
        callSiteArray[60].callStatic(Assert.class, (Object)saved, subject);
        callSiteArray[61].callStatic(EasyMock.class, subject);
    }

    @Test
    public void testSaveWithoutSessionOrPrincipalsOrAuthentication() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[62].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[63].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[64].callStatic(EasyMock.class, Session.class);
        callSiteArray[65].call(callSiteArray[66].callStatic(EasyMock.class, callSiteArray[67].call(subject, (Object)false)), null);
        callSiteArray[68].call(callSiteArray[69].callStatic(EasyMock.class, callSiteArray[70].call(subject)), (Object)false);
        callSiteArray[71].call(callSiteArray[72].callStatic(EasyMock.class, callSiteArray[73].callGetProperty(subject)), null);
        callSiteArray[74].call(callSiteArray[75].call(callSiteArray[76].callStatic(EasyMock.class, callSiteArray[77].call(subject, (Object)false)), null));
        callSiteArray[78].call(callSiteArray[79].callStatic(EasyMock.class, callSiteArray[80].callGetProperty(subject)), (Object)false);
        callSiteArray[81].callStatic(EasyMock.class, subject, session);
        callSiteArray[82].call(dao, subject);
        callSiteArray[83].callStatic(EasyMock.class, subject, session);
    }

    @Test
    public void testMergePrincipalsWithDelegatingSubject() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        String sessionId = "sessionId";
        Object principals = callSiteArray[84].callStatic(EasyMock.class, PrincipalCollection.class);
        Object runAsPrincipals = callSiteArray[85].callStatic(EasyMock.class, PrincipalCollection.class);
        Object session = callSiteArray[86].callStatic(EasyMock.class, Session.class);
        Object securityManager = callSiteArray[87].callStatic(EasyMock.class, SecurityManager.class);
        callSiteArray[88].call(callSiteArray[89].callStatic(EasyMock.class, callSiteArray[90].call(session)), (Object)sessionId);
        callSiteArray[91].call(callSiteArray[92].callStatic(EasyMock.class, callSiteArray[93].call(session, callSiteArray[94].callStatic(EasyMock.class, callSiteArray[95].callGetProperty(DelegatingSubject.class)))), callSiteArray[96].call(Arrays.class, runAsPrincipals));
        callSiteArray[97].call(callSiteArray[98].callStatic(EasyMock.class, callSiteArray[99].call(principals)), (Object)false);
        callSiteArray[100].call(callSiteArray[101].callStatic(EasyMock.class, callSiteArray[102].call(session, callSiteArray[103].callStatic(EasyMock.class, callSiteArray[104].callGetProperty(DefaultSubjectContext.class)))), null);
        callSiteArray[105].call(session, callSiteArray[106].callStatic(EasyMock.class, callSiteArray[107].callGetProperty(DefaultSubjectContext.class)), callSiteArray[108].callStatic(EasyMock.class, principals));
        callSiteArray[109].callStatic(EasyMock.class, principals, runAsPrincipals, session, securityManager);
        Object subject = callSiteArray[110].callConstructor(DelegatingSubject.class, ArrayUtil.createArray((Object)principals, (Object)true, (Object)"localhost", (Object)session, (Object)true, (Object)securityManager));
        callSiteArray[111].call(callSiteArray[112].callConstructor(DefaultSubjectDAO.class), subject);
        callSiteArray[113].callStatic(EasyMock.class, principals, runAsPrincipals, session, securityManager);
    }

    @Test
    public void testMergePrincipalsWithSubjectPrincipalsButWithoutSession() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[114].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[115].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[116].callStatic(EasyMock.class, Session.class);
        Object principals = callSiteArray[117].callStatic(EasyMock.class, PrincipalCollection.class);
        callSiteArray[118].call(callSiteArray[119].callStatic(EasyMock.class, callSiteArray[120].callGetProperty(subject)), (Object)false);
        callSiteArray[121].call(callSiteArray[122].callStatic(EasyMock.class, callSiteArray[123].callGetProperty(subject)), principals);
        callSiteArray[124].call(callSiteArray[125].callStatic(EasyMock.class, callSiteArray[126].call(subject, (Object)false)), null);
        callSiteArray[127].call(callSiteArray[128].call(callSiteArray[129].callStatic(EasyMock.class, callSiteArray[130].call(principals)), (Object)false));
        callSiteArray[131].call(callSiteArray[132].callStatic(EasyMock.class, callSiteArray[133].call(subject)), session);
        callSiteArray[134].call(session, callSiteArray[135].callStatic(EasyMock.class, callSiteArray[136].callGetProperty(DefaultSubjectContext.class)), callSiteArray[137].callStatic(EasyMock.class, principals));
        callSiteArray[138].callStatic(EasyMock.class, subject, session, principals);
        callSiteArray[139].call(dao, subject);
        callSiteArray[140].callStatic(EasyMock.class, subject, session, principals);
    }

    @Test
    public void testMergePrincipalsWithoutSubjectPrincipalsOrSessionPrincipals() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[141].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[142].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[143].callStatic(EasyMock.class, Session.class);
        callSiteArray[144].call(callSiteArray[145].callStatic(EasyMock.class, callSiteArray[146].callGetProperty(subject)), (Object)false);
        callSiteArray[147].call(callSiteArray[148].callStatic(EasyMock.class, callSiteArray[149].callGetProperty(subject)), null);
        callSiteArray[150].call(callSiteArray[151].call(callSiteArray[152].callStatic(EasyMock.class, callSiteArray[153].call(subject, (Object)false)), session));
        callSiteArray[154].call(callSiteArray[155].callStatic(EasyMock.class, callSiteArray[156].call(session, callSiteArray[157].callStatic(EasyMock.class, callSiteArray[158].callGetProperty(DefaultSubjectContext.class)))), null);
        callSiteArray[159].callStatic(EasyMock.class, subject, session);
        callSiteArray[160].call(dao, subject);
        callSiteArray[161].callStatic(EasyMock.class, subject, session);
    }

    @Test
    public void testMergePrincipalsWithoutSubjectPrincipalsButWithSessionPrincipals() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[162].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[163].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[164].callStatic(EasyMock.class, Session.class);
        Object sessionPrincipals = callSiteArray[165].callStatic(EasyMock.class, PrincipalCollection.class);
        callSiteArray[166].call(callSiteArray[167].callStatic(EasyMock.class, callSiteArray[168].callGetProperty(subject)), (Object)false);
        callSiteArray[169].call(callSiteArray[170].callStatic(EasyMock.class, callSiteArray[171].callGetProperty(subject)), null);
        callSiteArray[172].call(callSiteArray[173].call(callSiteArray[174].callStatic(EasyMock.class, callSiteArray[175].call(subject, (Object)false)), session));
        callSiteArray[176].call(callSiteArray[177].callStatic(EasyMock.class, callSiteArray[178].call(session, callSiteArray[179].callStatic(EasyMock.class, callSiteArray[180].callGetProperty(DefaultSubjectContext.class)))), sessionPrincipals);
        callSiteArray[181].call(callSiteArray[182].callStatic(EasyMock.class, callSiteArray[183].call(sessionPrincipals)), (Object)false);
        callSiteArray[184].call(callSiteArray[185].callStatic(EasyMock.class, callSiteArray[186].call(session, callSiteArray[187].callStatic(EasyMock.class, callSiteArray[188].callGetProperty(DefaultSubjectContext.class)))), sessionPrincipals);
        callSiteArray[189].callStatic(EasyMock.class, subject, session, sessionPrincipals);
        callSiteArray[190].call(dao, subject);
        callSiteArray[191].callStatic(EasyMock.class, subject, session, sessionPrincipals);
    }

    @Test
    public void testMergePrincipalsWithSubjectPrincipalsButWithDifferentSessionPrincipals() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object sessionPrincipals = callSiteArray[192].callStatic(EasyMock.class, PrincipalCollection.class);
        callSiteArray[193].callStatic(EasyMock.class, sessionPrincipals);
        callSiteArray[194].callCurrent((GroovyObject)this, sessionPrincipals);
        callSiteArray[195].callStatic(EasyMock.class, sessionPrincipals);
    }

    private void testMergePrincipalsWithSubjectPrincipalsButWithSessionPrincipals(PrincipalCollection sessionPrincipals) {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[196].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[197].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[198].callStatic(EasyMock.class, Session.class);
        Object subjectPrincipals = callSiteArray[199].callStatic(EasyMock.class, PrincipalCollection.class);
        callSiteArray[200].call(callSiteArray[201].callStatic(EasyMock.class, callSiteArray[202].callGetProperty(subject)), (Object)false);
        callSiteArray[203].call(callSiteArray[204].callStatic(EasyMock.class, callSiteArray[205].callGetProperty(subject)), subjectPrincipals);
        callSiteArray[206].call(callSiteArray[207].callStatic(EasyMock.class, callSiteArray[208].call(subject, (Object)false)), session);
        callSiteArray[209].call(callSiteArray[210].callStatic(EasyMock.class, callSiteArray[211].call(subjectPrincipals)), (Object)false);
        callSiteArray[212].call(callSiteArray[213].callStatic(EasyMock.class, callSiteArray[214].call(session, callSiteArray[215].callStatic(EasyMock.class, callSiteArray[216].callGetProperty(DefaultSubjectContext.class)))), (Object)sessionPrincipals);
        callSiteArray[217].call(session, callSiteArray[218].callStatic(EasyMock.class, callSiteArray[219].callGetProperty(DefaultSubjectContext.class)), callSiteArray[220].callStatic(EasyMock.class, subjectPrincipals));
        callSiteArray[221].callStatic(EasyMock.class, subject, session, subjectPrincipals);
        callSiteArray[222].call(dao, subject);
        callSiteArray[223].callStatic(EasyMock.class, subject, session, subjectPrincipals);
    }

    @Test
    public void testMergeAuthcWithSubjectAuthcButWithoutSession() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[224].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[225].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[226].callStatic(EasyMock.class, Session.class);
        callSiteArray[227].call(callSiteArray[228].callStatic(EasyMock.class, callSiteArray[229].call(subject, (Object)false)), null);
        callSiteArray[230].call(callSiteArray[231].callStatic(EasyMock.class, callSiteArray[232].callGetProperty(subject)), (Object)true);
        callSiteArray[233].call(callSiteArray[234].callStatic(EasyMock.class, callSiteArray[235].call(subject)), session);
        callSiteArray[236].call(session, callSiteArray[237].callStatic(EasyMock.class, callSiteArray[238].callGetProperty(DefaultSubjectContext.class)), callSiteArray[239].callStatic(EasyMock.class, callSiteArray[240].callGetProperty(Boolean.class)));
        callSiteArray[241].callStatic(EasyMock.class, subject, session);
        callSiteArray[242].call(dao, subject);
        callSiteArray[243].callStatic(EasyMock.class, subject, session);
    }

    @Test
    public void testMergeAuthcWithoutSubjectAuthcOrSessionAuthc() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[244].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[245].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[246].callStatic(EasyMock.class, Session.class);
        callSiteArray[247].call(callSiteArray[248].call(callSiteArray[249].callStatic(EasyMock.class, callSiteArray[250].call(subject, (Object)false)), session));
        callSiteArray[251].call(callSiteArray[252].callStatic(EasyMock.class, callSiteArray[253].callGetProperty(subject)), (Object)false);
        callSiteArray[254].call(callSiteArray[255].callStatic(EasyMock.class, callSiteArray[256].call(session, callSiteArray[257].callStatic(EasyMock.class, callSiteArray[258].callGetProperty(DefaultSubjectContext.class)))), null);
        callSiteArray[259].callStatic(EasyMock.class, subject, session);
        callSiteArray[260].call(dao, subject);
        callSiteArray[261].callStatic(EasyMock.class, subject, session);
    }

    @Test
    public void testMergeAuthcWithoutSubjectAuthcButWithSessionAuthc() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[262].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[263].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[264].callStatic(EasyMock.class, Session.class);
        callSiteArray[265].call(callSiteArray[266].call(callSiteArray[267].callStatic(EasyMock.class, callSiteArray[268].call(subject, (Object)false)), session));
        callSiteArray[269].call(callSiteArray[270].callStatic(EasyMock.class, callSiteArray[271].callGetProperty(subject)), (Object)false);
        callSiteArray[272].call(callSiteArray[273].callStatic(EasyMock.class, callSiteArray[274].call(session, callSiteArray[275].callStatic(EasyMock.class, callSiteArray[276].callGetProperty(DefaultSubjectContext.class)))), callSiteArray[277].callGetProperty(Boolean.class));
        callSiteArray[278].call(callSiteArray[279].callStatic(EasyMock.class, callSiteArray[280].call(session, callSiteArray[281].callStatic(EasyMock.class, callSiteArray[282].callGetProperty(DefaultSubjectContext.class)))), callSiteArray[283].callGetProperty(Boolean.class));
        callSiteArray[284].callStatic(EasyMock.class, subject, session);
        callSiteArray[285].call(dao, subject);
        callSiteArray[286].callStatic(EasyMock.class, subject, session);
    }

    @Test
    public void testMergeAuthcWithSubjectAuthcButWithoutSessionAuthc() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        callSiteArray[287].callCurrent((GroovyObject)this, null);
    }

    @Test
    public void testMergeAuthcWithSubjectAuthcButWithDifferentSessionAuthc() {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        callSiteArray[288].callCurrent((GroovyObject)this, callSiteArray[289].callGetProperty(Boolean.class));
    }

    private void testMergeAuthcWithSubjectAuthcButWithSessionAuthc(Boolean value) {
        CallSite[] callSiteArray = DefaultSubjectDAOTest.$getCallSiteArray();
        Object dao = callSiteArray[290].callConstructor(DefaultSubjectDAO.class);
        Object subject = callSiteArray[291].callStatic(EasyMock.class, Subject.class);
        Object session = callSiteArray[292].callStatic(EasyMock.class, Session.class);
        callSiteArray[293].call(callSiteArray[294].callStatic(EasyMock.class, callSiteArray[295].call(subject, (Object)false)), session);
        callSiteArray[296].call(callSiteArray[297].callStatic(EasyMock.class, callSiteArray[298].callGetProperty(subject)), (Object)true);
        callSiteArray[299].call(callSiteArray[300].callStatic(EasyMock.class, callSiteArray[301].call(session, callSiteArray[302].callStatic(EasyMock.class, callSiteArray[303].callGetProperty(DefaultSubjectContext.class)))), (Object)value);
        callSiteArray[304].call(session, callSiteArray[305].callStatic(EasyMock.class, callSiteArray[306].callGetProperty(DefaultSubjectContext.class)), callSiteArray[307].callStatic(EasyMock.class, callSiteArray[308].callGetProperty(Boolean.class)));
        callSiteArray[309].callStatic(EasyMock.class, subject, session);
        callSiteArray[310].call(dao, subject);
        callSiteArray[311].callStatic(EasyMock.class, subject, session);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultSubjectDAOTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "assertTrue";
        stringArray[2] = "sessionStorageEvaluator";
        stringArray[3] = "assertTrue";
        stringArray[4] = "isSessionStorageEnabled";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "createStrictMock";
        stringArray[7] = "andReturn";
        stringArray[8] = "expect";
        stringArray[9] = "getSession";
        stringArray[10] = "replay";
        stringArray[11] = "assertTrue";
        stringArray[12] = "isSessionStorageEnabled";
        stringArray[13] = "verify";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "createMock";
        stringArray[16] = "createStrictMock";
        stringArray[17] = "andReturn";
        stringArray[18] = "expect";
        stringArray[19] = "isSessionStorageEnabled";
        stringArray[20] = "same";
        stringArray[21] = "replay";
        stringArray[22] = "assertTrue";
        stringArray[23] = "isSessionStorageEnabled";
        stringArray[24] = "verify";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "createStrictMock";
        stringArray[27] = "andReturn";
        stringArray[28] = "expect";
        stringArray[29] = "getSession";
        stringArray[30] = "replay";
        stringArray[31] = "delete";
        stringArray[32] = "verify";
        stringArray[33] = "<$constructor$>";
        stringArray[34] = "createStrictMock";
        stringArray[35] = "createStrictMock";
        stringArray[36] = "andReturn";
        stringArray[37] = "expect";
        stringArray[38] = "getSession";
        stringArray[39] = "andReturn";
        stringArray[40] = "expect";
        stringArray[41] = "removeAttribute";
        stringArray[42] = "eq";
        stringArray[43] = "AUTHENTICATED_SESSION_KEY";
        stringArray[44] = "andReturn";
        stringArray[45] = "expect";
        stringArray[46] = "removeAttribute";
        stringArray[47] = "eq";
        stringArray[48] = "PRINCIPALS_SESSION_KEY";
        stringArray[49] = "replay";
        stringArray[50] = "delete";
        stringArray[51] = "verify";
        stringArray[52] = "<$constructor$>";
        stringArray[53] = "createStrictMock";
        stringArray[54] = "andReturn";
        stringArray[55] = "expect";
        stringArray[56] = "getSession";
        stringArray[57] = "sessionStorageEvaluator";
        stringArray[58] = "replay";
        stringArray[59] = "save";
        stringArray[60] = "assertSame";
        stringArray[61] = "verify";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "createStrictMock";
        stringArray[64] = "createStrictMock";
        stringArray[65] = "andReturn";
        stringArray[66] = "expect";
        stringArray[67] = "getSession";
        stringArray[68] = "andReturn";
        stringArray[69] = "expect";
        stringArray[70] = "isRunAs";
        stringArray[71] = "andReturn";
        stringArray[72] = "expect";
        stringArray[73] = "principals";
        stringArray[74] = "anyTimes";
        stringArray[75] = "andReturn";
        stringArray[76] = "expect";
        stringArray[77] = "getSession";
        stringArray[78] = "andReturn";
        stringArray[79] = "expect";
        stringArray[80] = "authenticated";
        stringArray[81] = "replay";
        stringArray[82] = "save";
        stringArray[83] = "verify";
        stringArray[84] = "createStrictMock";
        stringArray[85] = "createStrictMock";
        stringArray[86] = "createStrictMock";
        stringArray[87] = "createStrictMock";
        stringArray[88] = "andStubReturn";
        stringArray[89] = "expect";
        stringArray[90] = "getId";
        stringArray[91] = "andReturn";
        stringArray[92] = "expect";
        stringArray[93] = "getAttribute";
        stringArray[94] = "eq";
        stringArray[95] = "RUN_AS_PRINCIPALS_SESSION_KEY";
        stringArray[96] = "asList";
        stringArray[97] = "andStubReturn";
        stringArray[98] = "expect";
        stringArray[99] = "isEmpty";
        stringArray[100] = "andReturn";
        stringArray[101] = "expect";
        stringArray[102] = "getAttribute";
        stringArray[103] = "eq";
        stringArray[104] = "PRINCIPALS_SESSION_KEY";
        stringArray[105] = "setAttribute";
        stringArray[106] = "eq";
        stringArray[107] = "PRINCIPALS_SESSION_KEY";
        stringArray[108] = "same";
        stringArray[109] = "replay";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "mergePrincipals";
        stringArray[112] = "<$constructor$>";
        stringArray[113] = "verify";
        stringArray[114] = "<$constructor$>";
        stringArray[115] = "createStrictMock";
        stringArray[116] = "createStrictMock";
        stringArray[117] = "createStrictMock";
        stringArray[118] = "andReturn";
        stringArray[119] = "expect";
        stringArray[120] = "runAs";
        stringArray[121] = "andReturn";
        stringArray[122] = "expect";
        stringArray[123] = "principals";
        stringArray[124] = "andReturn";
        stringArray[125] = "expect";
        stringArray[126] = "getSession";
        stringArray[127] = "anyTimes";
        stringArray[128] = "andReturn";
        stringArray[129] = "expect";
        stringArray[130] = "isEmpty";
        stringArray[131] = "andReturn";
        stringArray[132] = "expect";
        stringArray[133] = "getSession";
        stringArray[134] = "setAttribute";
        stringArray[135] = "eq";
        stringArray[136] = "PRINCIPALS_SESSION_KEY";
        stringArray[137] = "same";
        stringArray[138] = "replay";
        stringArray[139] = "mergePrincipals";
        stringArray[140] = "verify";
        stringArray[141] = "<$constructor$>";
        stringArray[142] = "createStrictMock";
        stringArray[143] = "createStrictMock";
        stringArray[144] = "andReturn";
        stringArray[145] = "expect";
        stringArray[146] = "runAs";
        stringArray[147] = "andReturn";
        stringArray[148] = "expect";
        stringArray[149] = "principals";
        stringArray[150] = "anyTimes";
        stringArray[151] = "andReturn";
        stringArray[152] = "expect";
        stringArray[153] = "getSession";
        stringArray[154] = "andReturn";
        stringArray[155] = "expect";
        stringArray[156] = "getAttribute";
        stringArray[157] = "eq";
        stringArray[158] = "PRINCIPALS_SESSION_KEY";
        stringArray[159] = "replay";
        stringArray[160] = "mergePrincipals";
        stringArray[161] = "verify";
        stringArray[162] = "<$constructor$>";
        stringArray[163] = "createStrictMock";
        stringArray[164] = "createStrictMock";
        stringArray[165] = "createStrictMock";
        stringArray[166] = "andReturn";
        stringArray[167] = "expect";
        stringArray[168] = "runAs";
        stringArray[169] = "andReturn";
        stringArray[170] = "expect";
        stringArray[171] = "principals";
        stringArray[172] = "anyTimes";
        stringArray[173] = "andReturn";
        stringArray[174] = "expect";
        stringArray[175] = "getSession";
        stringArray[176] = "andReturn";
        stringArray[177] = "expect";
        stringArray[178] = "getAttribute";
        stringArray[179] = "eq";
        stringArray[180] = "PRINCIPALS_SESSION_KEY";
        stringArray[181] = "andReturn";
        stringArray[182] = "expect";
        stringArray[183] = "isEmpty";
        stringArray[184] = "andReturn";
        stringArray[185] = "expect";
        stringArray[186] = "removeAttribute";
        stringArray[187] = "eq";
        stringArray[188] = "PRINCIPALS_SESSION_KEY";
        stringArray[189] = "replay";
        stringArray[190] = "mergePrincipals";
        stringArray[191] = "verify";
        stringArray[192] = "createStrictMock";
        stringArray[193] = "replay";
        stringArray[194] = "testMergePrincipalsWithSubjectPrincipalsButWithSessionPrincipals";
        stringArray[195] = "verify";
        stringArray[196] = "<$constructor$>";
        stringArray[197] = "createStrictMock";
        stringArray[198] = "createStrictMock";
        stringArray[199] = "createStrictMock";
        stringArray[200] = "andReturn";
        stringArray[201] = "expect";
        stringArray[202] = "runAs";
        stringArray[203] = "andReturn";
        stringArray[204] = "expect";
        stringArray[205] = "principals";
        stringArray[206] = "andReturn";
        stringArray[207] = "expect";
        stringArray[208] = "getSession";
        stringArray[209] = "andReturn";
        stringArray[210] = "expect";
        stringArray[211] = "isEmpty";
        stringArray[212] = "andReturn";
        stringArray[213] = "expect";
        stringArray[214] = "getAttribute";
        stringArray[215] = "eq";
        stringArray[216] = "PRINCIPALS_SESSION_KEY";
        stringArray[217] = "setAttribute";
        stringArray[218] = "eq";
        stringArray[219] = "PRINCIPALS_SESSION_KEY";
        stringArray[220] = "same";
        stringArray[221] = "replay";
        stringArray[222] = "mergePrincipals";
        stringArray[223] = "verify";
        stringArray[224] = "<$constructor$>";
        stringArray[225] = "createStrictMock";
        stringArray[226] = "createStrictMock";
        stringArray[227] = "andReturn";
        stringArray[228] = "expect";
        stringArray[229] = "getSession";
        stringArray[230] = "andReturn";
        stringArray[231] = "expect";
        stringArray[232] = "authenticated";
        stringArray[233] = "andReturn";
        stringArray[234] = "expect";
        stringArray[235] = "getSession";
        stringArray[236] = "setAttribute";
        stringArray[237] = "eq";
        stringArray[238] = "AUTHENTICATED_SESSION_KEY";
        stringArray[239] = "eq";
        stringArray[240] = "TRUE";
        stringArray[241] = "replay";
        stringArray[242] = "mergeAuthenticationState";
        stringArray[243] = "verify";
        stringArray[244] = "<$constructor$>";
        stringArray[245] = "createStrictMock";
        stringArray[246] = "createStrictMock";
        stringArray[247] = "anyTimes";
        stringArray[248] = "andReturn";
        stringArray[249] = "expect";
        stringArray[250] = "getSession";
        stringArray[251] = "andReturn";
        stringArray[252] = "expect";
        stringArray[253] = "authenticated";
        stringArray[254] = "andReturn";
        stringArray[255] = "expect";
        stringArray[256] = "getAttribute";
        stringArray[257] = "eq";
        stringArray[258] = "AUTHENTICATED_SESSION_KEY";
        stringArray[259] = "replay";
        stringArray[260] = "mergeAuthenticationState";
        stringArray[261] = "verify";
        stringArray[262] = "<$constructor$>";
        stringArray[263] = "createStrictMock";
        stringArray[264] = "createStrictMock";
        stringArray[265] = "anyTimes";
        stringArray[266] = "andReturn";
        stringArray[267] = "expect";
        stringArray[268] = "getSession";
        stringArray[269] = "andReturn";
        stringArray[270] = "expect";
        stringArray[271] = "authenticated";
        stringArray[272] = "andReturn";
        stringArray[273] = "expect";
        stringArray[274] = "getAttribute";
        stringArray[275] = "eq";
        stringArray[276] = "AUTHENTICATED_SESSION_KEY";
        stringArray[277] = "TRUE";
        stringArray[278] = "andReturn";
        stringArray[279] = "expect";
        stringArray[280] = "removeAttribute";
        stringArray[281] = "eq";
        stringArray[282] = "AUTHENTICATED_SESSION_KEY";
        stringArray[283] = "TRUE";
        stringArray[284] = "replay";
        stringArray[285] = "mergeAuthenticationState";
        stringArray[286] = "verify";
        stringArray[287] = "testMergeAuthcWithSubjectAuthcButWithSessionAuthc";
        stringArray[288] = "testMergeAuthcWithSubjectAuthcButWithSessionAuthc";
        stringArray[289] = "FALSE";
        stringArray[290] = "<$constructor$>";
        stringArray[291] = "createStrictMock";
        stringArray[292] = "createStrictMock";
        stringArray[293] = "andReturn";
        stringArray[294] = "expect";
        stringArray[295] = "getSession";
        stringArray[296] = "andReturn";
        stringArray[297] = "expect";
        stringArray[298] = "authenticated";
        stringArray[299] = "andReturn";
        stringArray[300] = "expect";
        stringArray[301] = "getAttribute";
        stringArray[302] = "eq";
        stringArray[303] = "AUTHENTICATED_SESSION_KEY";
        stringArray[304] = "setAttribute";
        stringArray[305] = "eq";
        stringArray[306] = "AUTHENTICATED_SESSION_KEY";
        stringArray[307] = "eq";
        stringArray[308] = "TRUE";
        stringArray[309] = "replay";
        stringArray[310] = "mergeAuthenticationState";
        stringArray[311] = "verify";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[312];
        DefaultSubjectDAOTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DefaultSubjectDAOTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DefaultSubjectDAOTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

