/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.credential;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.credential.HashingPasswordService;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class PasswordMatcherTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public PasswordMatcherTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void testMissingPasswordService() {
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        Object matcher = callSiteArray[0].callConstructor(PasswordMatcher.class);
        Object var3_3 = null;
        ScriptBytecodeAdapter.setProperty(var3_3, null, (Object)matcher, (String)"passwordService");
        try {
            callSiteArray[1].call(matcher, null, null);
            callSiteArray[2].callStatic(Assert.class, (Object)"Test should fail due to lack of a configured PasswordService instance.");
        }
        catch (IllegalStateException expected) {
        }
    }

    @Test
    public void testStringPasswordComparison() {
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        Object service = callSiteArray[3].callStatic(EasyMock.class, PasswordService.class);
        Object token = callSiteArray[4].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[5].callStatic(EasyMock.class, AuthenticationInfo.class);
        String submittedPassword = "plaintext";
        String savedPassword = "encrypted";
        callSiteArray[6].call(callSiteArray[7].callStatic(EasyMock.class, callSiteArray[8].callGetProperty(token)), (Object)submittedPassword);
        callSiteArray[9].call(callSiteArray[10].callStatic(EasyMock.class, callSiteArray[11].callGetProperty(info)), (Object)savedPassword);
        callSiteArray[12].call(callSiteArray[13].callStatic(EasyMock.class, callSiteArray[14].call(service, callSiteArray[15].callStatic(EasyMock.class, (Object)submittedPassword), callSiteArray[16].callStatic(EasyMock.class, (Object)savedPassword))), (Object)true);
        callSiteArray[17].callStatic(EasyMock.class, token, info, service);
        Object matcher = callSiteArray[18].callConstructor(PasswordMatcher.class);
        Object object = service;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)matcher, (String)"passwordService");
        callSiteArray[19].callStatic(Assert.class, service, callSiteArray[20].callGetProperty(matcher));
        callSiteArray[21].callStatic(Assert.class, callSiteArray[22].call(matcher, token, info));
        callSiteArray[23].callStatic(EasyMock.class, token, info, service);
    }

    @Test
    public void testHashComparisonWithoutHashedPasswordService() {
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        Object service = callSiteArray[24].callStatic(EasyMock.class, PasswordService.class);
        Object token = callSiteArray[25].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[26].callStatic(EasyMock.class, AuthenticationInfo.class);
        String submittedPassword = "plaintext";
        Object savedPassword = callSiteArray[27].callConstructor(Sha256Hash.class, (Object)"plaintext");
        callSiteArray[28].call(callSiteArray[29].callStatic(EasyMock.class, callSiteArray[30].callGetProperty(token)), (Object)submittedPassword);
        callSiteArray[31].call(callSiteArray[32].callStatic(EasyMock.class, callSiteArray[33].callGetProperty(info)), savedPassword);
        callSiteArray[34].callStatic(EasyMock.class, token, info, service);
        Object matcher = callSiteArray[35].callConstructor(PasswordMatcher.class);
        Object object = service;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)matcher, (String)"passwordService");
        callSiteArray[36].callStatic(Assert.class, service, callSiteArray[37].callGetProperty(matcher));
        try {
            callSiteArray[38].callStatic(Assert.class, callSiteArray[39].call(matcher, token, info));
            callSiteArray[40].callStatic(Assert.class, (Object)"matcher should fail since PasswordService is not a HashingPasswordService");
        }
        catch (IllegalStateException expected) {
        }
        callSiteArray[41].callStatic(EasyMock.class, token, info, service);
    }

    @Test
    public void testHashComparison() {
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        Object service = callSiteArray[42].callStatic(EasyMock.class, HashingPasswordService.class);
        Object token = callSiteArray[43].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[44].callStatic(EasyMock.class, AuthenticationInfo.class);
        String submittedPassword = "plaintext";
        Object savedPassword = callSiteArray[45].callConstructor(Sha256Hash.class, (Object)"plaintext");
        callSiteArray[46].call(callSiteArray[47].callStatic(EasyMock.class, callSiteArray[48].callGetProperty(token)), (Object)submittedPassword);
        callSiteArray[49].call(callSiteArray[50].callStatic(EasyMock.class, callSiteArray[51].callGetProperty(info)), savedPassword);
        callSiteArray[52].call(callSiteArray[53].callStatic(EasyMock.class, callSiteArray[54].call(service, (Object)submittedPassword, savedPassword)), (Object)true);
        callSiteArray[55].callStatic(EasyMock.class, token, info, service);
        Object matcher = callSiteArray[56].callConstructor(PasswordMatcher.class);
        Object object = service;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)matcher, (String)"passwordService");
        callSiteArray[57].callStatic(Assert.class, service, callSiteArray[58].callGetProperty(matcher));
        callSiteArray[59].callStatic(Assert.class, callSiteArray[60].call(matcher, token, info));
        callSiteArray[61].callStatic(EasyMock.class, token, info, service);
    }

    @Test
    public void testCharArrayComparison() {
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        Object service = callSiteArray[62].callStatic(EasyMock.class, PasswordService.class);
        Object token = callSiteArray[63].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[64].callStatic(EasyMock.class, AuthenticationInfo.class);
        String submittedPassword = "foo";
        String savedPasswordAsString = "foo";
        Object savedPassword = callSiteArray[65].call((Object)savedPasswordAsString);
        callSiteArray[66].call(callSiteArray[67].callStatic(EasyMock.class, callSiteArray[68].callGetProperty(token)), (Object)submittedPassword);
        callSiteArray[69].call(callSiteArray[70].callStatic(EasyMock.class, callSiteArray[71].callGetProperty(info)), savedPassword);
        callSiteArray[72].call(callSiteArray[73].callStatic(EasyMock.class, callSiteArray[74].call(service, callSiteArray[75].callStatic(EasyMock.class, (Object)submittedPassword), callSiteArray[76].callStatic(EasyMock.class, (Object)savedPasswordAsString))), (Object)true);
        callSiteArray[77].callStatic(EasyMock.class, token, info, service);
        Object matcher = callSiteArray[78].callConstructor(PasswordMatcher.class);
        Object object = service;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)matcher, (String)"passwordService");
        callSiteArray[79].callStatic(Assert.class, service, callSiteArray[80].callGetProperty(matcher));
        callSiteArray[81].callStatic(Assert.class, callSiteArray[82].call(matcher, token, info));
        callSiteArray[83].callStatic(EasyMock.class, token, info, service);
    }

    @Test
    public void testUnexpectedSavedCredentialsType() {
        CallSite[] callSiteArray = PasswordMatcherTest.$getCallSiteArray();
        Object service = callSiteArray[84].callStatic(EasyMock.class, HashingPasswordService.class);
        Object token = callSiteArray[85].callStatic(EasyMock.class, AuthenticationToken.class);
        Object info = callSiteArray[86].callStatic(EasyMock.class, AuthenticationInfo.class);
        String submittedPassword = "plaintext";
        Integer savedPassword = 23;
        callSiteArray[87].call(callSiteArray[88].callStatic(EasyMock.class, callSiteArray[89].callGetProperty(token)), (Object)submittedPassword);
        callSiteArray[90].call(callSiteArray[91].callStatic(EasyMock.class, callSiteArray[92].callGetProperty(info)), (Object)savedPassword);
        callSiteArray[93].callStatic(EasyMock.class, token, info, service);
        Object matcher = callSiteArray[94].callConstructor(PasswordMatcher.class);
        Object object = service;
        ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)matcher, (String)"passwordService");
        callSiteArray[95].callStatic(Assert.class, service, callSiteArray[96].callGetProperty(matcher));
        try {
            callSiteArray[97].callStatic(Assert.class, callSiteArray[98].call(matcher, token, info));
            callSiteArray[99].callStatic(Assert.class, (Object)"Saved credentials should be either a String or Hash instance.");
        }
        catch (IllegalArgumentException expected) {
        }
        callSiteArray[100].callStatic(EasyMock.class, token, info, service);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != PasswordMatcherTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "doCredentialsMatch";
        stringArray[2] = "fail";
        stringArray[3] = "createMock";
        stringArray[4] = "createMock";
        stringArray[5] = "createMock";
        stringArray[6] = "andReturn";
        stringArray[7] = "expect";
        stringArray[8] = "credentials";
        stringArray[9] = "andReturn";
        stringArray[10] = "expect";
        stringArray[11] = "credentials";
        stringArray[12] = "andReturn";
        stringArray[13] = "expect";
        stringArray[14] = "passwordsMatch";
        stringArray[15] = "eq";
        stringArray[16] = "eq";
        stringArray[17] = "replay";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "assertSame";
        stringArray[20] = "passwordService";
        stringArray[21] = "assertTrue";
        stringArray[22] = "doCredentialsMatch";
        stringArray[23] = "verify";
        stringArray[24] = "createMock";
        stringArray[25] = "createMock";
        stringArray[26] = "createMock";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "andReturn";
        stringArray[29] = "expect";
        stringArray[30] = "credentials";
        stringArray[31] = "andReturn";
        stringArray[32] = "expect";
        stringArray[33] = "credentials";
        stringArray[34] = "replay";
        stringArray[35] = "<$constructor$>";
        stringArray[36] = "assertSame";
        stringArray[37] = "passwordService";
        stringArray[38] = "assertTrue";
        stringArray[39] = "doCredentialsMatch";
        stringArray[40] = "fail";
        stringArray[41] = "verify";
        stringArray[42] = "createMock";
        stringArray[43] = "createMock";
        stringArray[44] = "createMock";
        stringArray[45] = "<$constructor$>";
        stringArray[46] = "andReturn";
        stringArray[47] = "expect";
        stringArray[48] = "credentials";
        stringArray[49] = "andReturn";
        stringArray[50] = "expect";
        stringArray[51] = "credentials";
        stringArray[52] = "andReturn";
        stringArray[53] = "expect";
        stringArray[54] = "passwordsMatch";
        stringArray[55] = "replay";
        stringArray[56] = "<$constructor$>";
        stringArray[57] = "assertSame";
        stringArray[58] = "passwordService";
        stringArray[59] = "assertTrue";
        stringArray[60] = "doCredentialsMatch";
        stringArray[61] = "verify";
        stringArray[62] = "createMock";
        stringArray[63] = "createMock";
        stringArray[64] = "createMock";
        stringArray[65] = "toCharArray";
        stringArray[66] = "andReturn";
        stringArray[67] = "expect";
        stringArray[68] = "credentials";
        stringArray[69] = "andReturn";
        stringArray[70] = "expect";
        stringArray[71] = "credentials";
        stringArray[72] = "andReturn";
        stringArray[73] = "expect";
        stringArray[74] = "passwordsMatch";
        stringArray[75] = "eq";
        stringArray[76] = "eq";
        stringArray[77] = "replay";
        stringArray[78] = "<$constructor$>";
        stringArray[79] = "assertSame";
        stringArray[80] = "passwordService";
        stringArray[81] = "assertTrue";
        stringArray[82] = "doCredentialsMatch";
        stringArray[83] = "verify";
        stringArray[84] = "createMock";
        stringArray[85] = "createMock";
        stringArray[86] = "createMock";
        stringArray[87] = "andReturn";
        stringArray[88] = "expect";
        stringArray[89] = "credentials";
        stringArray[90] = "andReturn";
        stringArray[91] = "expect";
        stringArray[92] = "credentials";
        stringArray[93] = "replay";
        stringArray[94] = "<$constructor$>";
        stringArray[95] = "assertSame";
        stringArray[96] = "passwordService";
        stringArray[97] = "assertTrue";
        stringArray[98] = "doCredentialsMatch";
        stringArray[99] = "fail";
        stringArray[100] = "verify";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[101];
        PasswordMatcherTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(PasswordMatcherTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = PasswordMatcherTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

