/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.SessionListenerAdapter;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.AbstractValidatingSessionManager;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SimpleSession;
import org.junit.Assert;
import org.junit.Test;

public class AbstractValidatingSessionManagerTest {
    @Test
    public void testValidateSessions() {
        final SimpleSession validSession = new SimpleSession();
        validSession.setId((Serializable)Integer.valueOf(1));
        final SimpleSession invalidSession = new SimpleSession();
        Calendar cal = Calendar.getInstance();
        Long expiredTimeout = 1800001L;
        cal.add(14, -expiredTimeout.intValue());
        Date past = cal.getTime();
        invalidSession.setStartTimestamp(past);
        invalidSession.setLastAccessTime(past);
        invalidSession.setId((Serializable)Integer.valueOf(2));
        final AtomicInteger expirationCount = new AtomicInteger();
        SessionListenerAdapter sessionListener = new SessionListenerAdapter(){

            public void onExpiration(Session session) {
                expirationCount.incrementAndGet();
            }
        };
        AbstractValidatingSessionManager sessionManager = new AbstractValidatingSessionManager(){

            protected Session retrieveSession(SessionKey key) throws UnknownSessionException {
                throw new UnsupportedOperationException("Should not be called in this test.");
            }

            protected Session doCreateSession(SessionContext initData) throws AuthorizationException {
                throw new UnsupportedOperationException("Should not be called in this test.");
            }

            protected Collection<Session> getActiveSessions() {
                ArrayList<Session> sessions = new ArrayList<Session>(2);
                sessions.add((Session)validSession);
                sessions.add((Session)invalidSession);
                return sessions;
            }
        };
        sessionManager.setSessionListeners(Arrays.asList(sessionListener));
        sessionManager.validateSessions();
        Assert.assertEquals((long)1L, (long)expirationCount.intValue());
    }

    @Test
    public void testNoMemoryLeakOnInvalidSessions() throws Exception {
        SessionListener sessionListener = new SessionListener(){

            public void onStart(Session session) {
                session.setAttribute((Object)"I love", (Object)"Romania");
            }

            public void onStop(Session session) {
                this.tryToCleanSession(session);
            }

            public void onExpiration(Session session) {
                this.tryToCleanSession(session);
            }

            private void tryToCleanSession(Session session) {
                Collection keys = session.getAttributeKeys();
                for (Object key : keys) {
                    session.removeAttribute(key);
                }
            }
        };
        DefaultSessionManager sessionManager = new DefaultSessionManager();
        sessionManager.setSessionListeners(Arrays.asList(sessionListener));
        Session session = sessionManager.start(null);
        Assert.assertEquals((long)1L, (long)sessionManager.getActiveSessions().size());
        session.setTimeout(0L);
        Thread.sleep(1L);
        sessionManager.validateSessions();
        Assert.assertEquals((long)0L, (long)sessionManager.getActiveSessions().size());
    }
}

