/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.authz.permission.WildcardPermission;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.UserIdPrincipal;
import org.apache.shiro.realm.UsernamePrincipal;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorizingRealmTest {
    AuthorizingRealm realm;
    private static final String USERNAME = "testuser";
    private static final String PASSWORD = "password";
    private static final int USER_ID = 12345;
    private static final String ROLE = "admin";
    private String localhost = "localhost";

    @Before
    public void setup() {
        this.realm = new AllowAllRealm();
    }

    @After
    public void tearDown() {
        this.realm = null;
    }

    @Test
    public void testDefaultConfig() {
        AuthenticationInfo info = this.realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken(USERNAME, PASSWORD, this.localhost));
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)this.realm.hasRole(info.getPrincipals(), ROLE));
        Object principal = info.getPrincipals().getPrimaryPrincipal();
        Assert.assertTrue((boolean)(principal instanceof UserIdPrincipal));
        UsernamePrincipal usernamePrincipal = (UsernamePrincipal)info.getPrincipals().oneByType(UsernamePrincipal.class);
        Assert.assertTrue((boolean)usernamePrincipal.getUsername().equals(USERNAME));
        UserIdPrincipal userIdPrincipal = (UserIdPrincipal)info.getPrincipals().oneByType(UserIdPrincipal.class);
        Assert.assertTrue((userIdPrincipal.getUserId() == 12345 ? 1 : 0) != 0);
        String stringPrincipal = (String)info.getPrincipals().oneByType(String.class);
        Assert.assertTrue((boolean)stringPrincipal.equals("12345testuser"));
    }

    @Test
    public void testCreateAccountOverride() {
        AllowAllRealm realm = new AllowAllRealm(){

            @Override
            protected AuthenticationInfo buildAuthenticationInfo(Object principal, Object credentials) {
                String username = (String)principal;
                UsernamePrincipal customPrincipal = new UsernamePrincipal(username);
                return new SimpleAccount((Object)customPrincipal, credentials, this.getName());
            }
        };
        AuthenticationInfo info = realm.getAuthenticationInfo((AuthenticationToken)new UsernamePasswordToken(USERNAME, PASSWORD, this.localhost));
        Assert.assertNotNull((Object)info);
        Assert.assertTrue((boolean)realm.hasRole(info.getPrincipals(), ROLE));
        Object principal = info.getPrincipals().getPrimaryPrincipal();
        Assert.assertTrue((boolean)(principal instanceof UsernamePrincipal));
        Assert.assertEquals((Object)USERNAME, (Object)((UsernamePrincipal)principal).getUsername());
    }

    @Test
    public void testNullAuthzInfo() {
        AuthorizingRealm realm = new AuthorizingRealm(){

            protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
                return null;
            }

            protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
                return null;
            }
        };
        UsernamePrincipal principal = new UsernamePrincipal("blah");
        SimplePrincipalCollection pCollection = new SimplePrincipalCollection((Object)principal, "nullAuthzRealm");
        ArrayList<WildcardPermission> permList = new ArrayList<WildcardPermission>();
        permList.add(new WildcardPermission("stringPerm1"));
        permList.add(new WildcardPermission("stringPerm2"));
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add("role1");
        roleList.add("role2");
        boolean thrown = false;
        try {
            realm.checkPermission((PrincipalCollection)pCollection, "stringPermission");
        }
        catch (UnauthorizedException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        thrown = false;
        try {
            realm.checkPermission((PrincipalCollection)pCollection, (Permission)new WildcardPermission("stringPermission"));
        }
        catch (UnauthorizedException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        thrown = false;
        try {
            realm.checkPermissions((PrincipalCollection)pCollection, new String[]{"stringPerm1", "stringPerm2"});
        }
        catch (UnauthorizedException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        thrown = false;
        try {
            realm.checkPermissions((PrincipalCollection)pCollection, permList);
        }
        catch (UnauthorizedException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        thrown = false;
        try {
            realm.checkRole((PrincipalCollection)pCollection, "role1");
        }
        catch (UnauthorizedException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        thrown = false;
        try {
            realm.checkRoles((PrincipalCollection)pCollection, roleList);
        }
        catch (UnauthorizedException e) {
            thrown = true;
        }
        Assert.assertTrue((boolean)thrown);
        Assert.assertFalse((boolean)realm.hasAllRoles((PrincipalCollection)pCollection, roleList));
        Assert.assertFalse((boolean)realm.hasRole((PrincipalCollection)pCollection, "role1"));
        this.assertArrayEquals(new boolean[]{false, false}, realm.hasRoles((PrincipalCollection)pCollection, roleList));
        Assert.assertFalse((boolean)realm.isPermitted((PrincipalCollection)pCollection, "perm1"));
        Assert.assertFalse((boolean)realm.isPermitted((PrincipalCollection)pCollection, (Permission)new WildcardPermission("perm1")));
        this.assertArrayEquals(new boolean[]{false, false}, realm.isPermitted((PrincipalCollection)pCollection, new String[]{"perm1", "perm2"}));
        this.assertArrayEquals(new boolean[]{false, false}, realm.isPermitted((PrincipalCollection)pCollection, permList));
        Assert.assertFalse((boolean)realm.isPermittedAll((PrincipalCollection)pCollection, new String[]{"perm1", "perm2"}));
        Assert.assertFalse((boolean)realm.isPermittedAll((PrincipalCollection)pCollection, permList));
    }

    @Test
    public void testRealmWithRolePermissionResolver() {
        UsernamePrincipal principal = new UsernamePrincipal("rolePermResolver");
        SimplePrincipalCollection pCollection = new SimplePrincipalCollection((Object)principal, "testRealmWithRolePermissionResolver");
        AllowAllRealm realm = new AllowAllRealm();
        realm.setRolePermissionResolver(new RolePermissionResolver(){

            public Collection<Permission> resolvePermissionsInRole(String roleString) {
                HashSet<Permission> permissions = new HashSet<Permission>();
                if (roleString.equals(AuthorizingRealmTest.ROLE)) {
                    permissions.add((Permission)new WildcardPermission("admin:perm1"));
                    permissions.add((Permission)new WildcardPermission("admin:perm2"));
                    permissions.add((Permission)new WildcardPermission("other:*:foo"));
                }
                return permissions;
            }
        });
        Assert.assertTrue((boolean)realm.hasRole((PrincipalCollection)pCollection, ROLE));
        Assert.assertTrue((boolean)realm.isPermitted((PrincipalCollection)pCollection, "admin:perm1"));
        Assert.assertTrue((boolean)realm.isPermitted((PrincipalCollection)pCollection, "admin:perm2"));
        Assert.assertFalse((boolean)realm.isPermitted((PrincipalCollection)pCollection, "admin:perm3"));
        Assert.assertTrue((boolean)realm.isPermitted((PrincipalCollection)pCollection, "other:bar:foo"));
    }

    private void assertArrayEquals(boolean[] expected, boolean[] actual) {
        if (expected.length != actual.length) {
            Assert.fail((String)("Expected array of length [" + expected.length + "] but received array of length [" + actual.length + "]"));
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail((String)("Expected index [" + i + "] to be [" + expected[i] + "] but was [" + actual[i] + "]"));
        }
    }

    public class AllowAllRealm
    extends AuthorizingRealm {
        public AllowAllRealm() {
            this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
            return this.buildAuthenticationInfo(token.getPrincipal(), token.getCredentials());
        }

        protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
            HashSet<String> roles = new HashSet<String>();
            roles.add(AuthorizingRealmTest.ROLE);
            return new SimpleAuthorizationInfo(roles);
        }

        protected AuthenticationInfo buildAuthenticationInfo(Object principal, Object credentials) {
            ArrayList<Object> principals = new ArrayList<Object>(3);
            principals.add(new UserIdPrincipal(12345));
            principals.add(new UsernamePrincipal(AuthorizingRealmTest.USERNAME));
            principals.add("12345testuser");
            return new SimpleAuthenticationInfo(principals, (Object)AuthorizingRealmTest.PASSWORD, this.getName());
        }
    }
}

