/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.config.Ini;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VMSingletonDefaultSecurityManagerTest {
    @Before
    public void setUp() {
        ThreadContext.remove();
    }

    @After
    public void tearDown() {
        ThreadContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVMSingleton() {
        DefaultSecurityManager sm = new DefaultSecurityManager();
        Ini ini = new Ini();
        Ini.Section section = ini.addSection("users");
        section.put("guest", "guest");
        sm.setRealm((Realm)new IniRealm(ini));
        SecurityUtils.setSecurityManager((SecurityManager)sm);
        try {
            Subject subject = SecurityUtils.getSubject();
            UsernamePasswordToken token = new UsernamePasswordToken("guest", "guest");
            subject.login((AuthenticationToken)token);
            subject.getSession().setAttribute((Object)"key", (Object)"value");
            Assert.assertTrue((boolean)subject.getSession().getAttribute((Object)"key").equals("value"));
            subject = SecurityUtils.getSubject();
            Assert.assertTrue((boolean)subject.isAuthenticated());
            Assert.assertTrue((boolean)subject.getSession().getAttribute((Object)"key").equals("value"));
        }
        finally {
            sm.destroy();
            SecurityUtils.setSecurityManager(null);
        }
    }
}

