/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import org.apache.shiro.mgt.AbstractRememberMeManager;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.SubjectContext;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.junit.Assert;
import org.junit.Test;

public class AbstractRememberMeManagerTest {
    @Test
    public void testGetRememberedPrincipalsWithEmptySerializedBytes() {
        DummyRememberMeManager rmm = new DummyRememberMeManager();
        PrincipalCollection principals = rmm.getRememberedPrincipals((SubjectContext)new DefaultSubjectContext());
        Assert.assertNull((Object)principals);
        rmm = new DummyRememberMeManager(){

            @Override
            protected byte[] getRememberedSerializedIdentity(SubjectContext subjectContext) {
                return null;
            }
        };
        principals = rmm.getRememberedPrincipals((SubjectContext)new DefaultSubjectContext());
        Assert.assertNull((Object)principals);
    }

    private static class DummyRememberMeManager
    extends AbstractRememberMeManager {
        private DummyRememberMeManager() {
        }

        public void forgetIdentity(SubjectContext subjectContext) {
        }

        protected void forgetIdentity(Subject subject) {
        }

        protected void rememberSerializedIdentity(Subject subject, byte[] serialized) {
        }

        protected byte[] getRememberedSerializedIdentity(SubjectContext subjectContext) {
            return new byte[0];
        }
    }
}

