/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.shiro.concurrent.SubjectAwareExecutorService;
import org.apache.shiro.subject.support.SubjectRunnable;
import org.apache.shiro.test.SecurityManagerTestSupport;
import org.easymock.EasyMock;
import org.junit.Test;

public class SubjectAwareExecutorServiceTest
extends SecurityManagerTestSupport {
    @Test
    public void testSubmitRunnable() {
        ExecutorService mockExecutorService = (ExecutorService)EasyMock.createNiceMock(ExecutorService.class);
        EasyMock.expect(mockExecutorService.submit((Runnable)EasyMock.isA(SubjectRunnable.class))).andReturn(new DummyFuture());
        EasyMock.replay((Object[])new Object[]{mockExecutorService});
        SubjectAwareExecutorService executor = new SubjectAwareExecutorService(mockExecutorService);
        Runnable testRunnable = new Runnable(){

            @Override
            public void run() {
                System.out.println("Hello World");
            }
        };
        executor.submit(testRunnable);
        EasyMock.verify((Object[])new Object[]{mockExecutorService});
    }

    private class DummyFuture<V>
    implements Future<V> {
        private DummyFuture() {
        }

        @Override
        public boolean cancel(boolean b) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return null;
        }

        @Override
        public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return null;
        }
    }
}

