/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.ModularRealmAuthorizer;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.RolePermissionResolver;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.PrincipalCollection;
import org.junit.Assert;
import org.junit.Test;

public class ModularRealmAuthorizerTest {
    @Test
    public void testSettingOfRolePermissionResolver() {
        ArrayList<MockAuthorizingRealm> realms = new ArrayList<MockAuthorizingRealm>();
        realms.add(new MockAuthorizingRealm());
        realms.add(new MockAuthorizingRealm());
        for (Realm realm : realms) {
            junit.framework.Assert.assertNull((Object)((AuthorizingRealm)realm).getRolePermissionResolver());
        }
        ModularRealmAuthorizer modRealmAuthz = new ModularRealmAuthorizer();
        modRealmAuthz.setRealms(realms);
        for (Realm realm : realms) {
            junit.framework.Assert.assertNull((Object)((AuthorizingRealm)realm).getRolePermissionResolver());
        }
        RolePermissionResolver rolePermissionResolver = new RolePermissionResolver(){

            public Collection<Permission> resolvePermissionsInRole(String roleString) {
                return null;
            }
        };
        modRealmAuthz.setRolePermissionResolver(rolePermissionResolver);
        for (Realm realm : realms) {
            junit.framework.Assert.assertTrue((((AuthorizingRealm)realm).getRolePermissionResolver() == rolePermissionResolver ? 1 : 0) != 0);
        }
        MockAuthorizingRealm mockAuthorizingRealm = new MockAuthorizingRealm();
        realms.add(mockAuthorizingRealm);
        modRealmAuthz.setRealms(realms);
        Assert.assertTrue((mockAuthorizingRealm.getRolePermissionResolver() == rolePermissionResolver ? 1 : 0) != 0);
    }

    class MockAuthorizingRealm
    extends AuthorizingRealm {
        MockAuthorizingRealm() {
        }

        protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
            return null;
        }

        protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
            return null;
        }
    }
}

