/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.shiro.authc.AbstractAuthenticator;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationListener;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractAuthenticatorTest {
    AbstractAuthenticator abstractAuthenticator;
    private final SimpleAuthenticationInfo info = new SimpleAuthenticationInfo((Object)"user1", (Object)"secret", "realmName");

    private AbstractAuthenticator createAuthcReturnNull() {
        return new AbstractAuthenticator(){

            protected AuthenticationInfo doAuthenticate(AuthenticationToken token) throws AuthenticationException {
                return null;
            }
        };
    }

    private AbstractAuthenticator createAuthcReturnValidAuthcInfo() {
        return new AbstractAuthenticator(){

            protected AuthenticationInfo doAuthenticate(AuthenticationToken token) throws AuthenticationException {
                return AbstractAuthenticatorTest.this.info;
            }
        };
    }

    private AuthenticationToken newToken() {
        return new UsernamePasswordToken("user1", "secret");
    }

    @Before
    public void setUp() {
        this.abstractAuthenticator = this.createAuthcReturnValidAuthcInfo();
    }

    @Test
    public void newAbstractAuthenticatorSecurityManagerConstructor() {
        this.abstractAuthenticator = new AbstractAuthenticator(){

            protected AuthenticationInfo doAuthenticate(AuthenticationToken token) throws AuthenticationException {
                return AbstractAuthenticatorTest.this.info;
            }
        };
    }

    @Test(expected=IllegalArgumentException.class)
    public void authenticateWithNullArgument() {
        this.abstractAuthenticator.authenticate(null);
    }

    @Test(expected=AuthenticationException.class)
    public void throwAuthenticationExceptionIfDoAuthenticateReturnsNull() {
        this.abstractAuthenticator = this.createAuthcReturnNull();
        this.abstractAuthenticator.authenticate(this.newToken());
    }

    @Test
    public void nonNullAuthenticationInfoAfterAuthenticate() {
        AuthenticationInfo authcInfo = this.abstractAuthenticator.authenticate(this.newToken());
        Assert.assertNotNull((Object)authcInfo);
    }

    @Test
    public void notifySuccessAfterDoAuthenticate() {
        AuthenticationListener mockListener = (AuthenticationListener)EasyMock.createMock(AuthenticationListener.class);
        this.abstractAuthenticator.getAuthenticationListeners().add(mockListener);
        AuthenticationToken token = this.newToken();
        mockListener.onSuccess(token, (AuthenticationInfo)this.info);
        EasyMock.replay((Object[])new Object[]{mockListener});
        this.abstractAuthenticator.authenticate(token);
        EasyMock.verify((Object[])new Object[]{mockListener});
    }

    @Test
    public void notifyFailureAfterDoAuthenticateThrowsAuthenticationException() {
        AuthenticationListener mockListener = (AuthenticationListener)EasyMock.createMock(AuthenticationListener.class);
        AuthenticationToken token = this.newToken();
        final AuthenticationException ae = new AuthenticationException("dummy exception to test notification");
        this.abstractAuthenticator = new AbstractAuthenticator(){

            protected AuthenticationInfo doAuthenticate(AuthenticationToken token) throws AuthenticationException {
                throw ae;
            }
        };
        this.abstractAuthenticator.getAuthenticationListeners().add(mockListener);
        mockListener.onFailure(token, ae);
        EasyMock.replay((Object[])new Object[]{mockListener});
        boolean exceptionThrown = false;
        try {
            this.abstractAuthenticator.authenticate(token);
        }
        catch (AuthenticationException e) {
            exceptionThrown = true;
            Assert.assertEquals((Object)((Object)e), (Object)((Object)ae));
        }
        EasyMock.verify((Object[])new Object[]{mockListener});
        if (!exceptionThrown) {
            Assert.fail((String)"An AuthenticationException should have been thrown during the notifyFailure test case.");
        }
    }

    @Test(expected=AuthenticationException.class)
    public void notifyFailureAfterDoAuthenticateThrowsNonAuthenticationException() {
        this.abstractAuthenticator = new AbstractAuthenticator(){

            protected AuthenticationInfo doAuthenticate(AuthenticationToken token) throws AuthenticationException {
                throw new IllegalArgumentException("not an AuthenticationException subclass");
            }
        };
        AuthenticationToken token = this.newToken();
        this.abstractAuthenticator.authenticate(token);
    }

    @Test
    public void logExceptionAfterDoAuthenticateThrowsNonAuthenticationException() {
        Logger logger = Logger.getLogger(AbstractAuthenticator.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimpleLayout layout = new SimpleLayout();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)out);
        logger.addAppender((Appender)appender);
        String expectedExceptionMessage = "exception thrown for test logExceptionAfterDoAuthenticateThrowsNonAuthenticationException";
        this.abstractAuthenticator = new AbstractAuthenticator(){

            protected AuthenticationInfo doAuthenticate(AuthenticationToken token) throws AuthenticationException {
                throw new IllegalArgumentException("exception thrown for test logExceptionAfterDoAuthenticateThrowsNonAuthenticationException");
            }
        };
        AuthenticationToken token = this.newToken();
        try {
            this.abstractAuthenticator.authenticate(token);
            Assert.fail((String)"the expected AuthenticationException was not thrown");
        }
        catch (AuthenticationException expectedException) {
            // empty catch block
        }
        String logMsg = out.toString();
        Assert.assertTrue((boolean)logMsg.contains("WARN"));
        Assert.assertTrue((boolean)logMsg.contains("java.lang.IllegalArgumentException: exception thrown for test logExceptionAfterDoAuthenticateThrowsNonAuthenticationException"));
        logger.removeAppender((Appender)appender);
    }
}

