/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.shiro.codec.CodecSupport;
import org.apache.shiro.crypto.AesCipherService;
import org.apache.shiro.util.ByteSource;
import org.junit.Test;

public class AesCipherServiceTest {
    private static final String[] PLAINTEXTS = new String[]{"Hello, this is a test.", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua."};

    @Test
    public void testBlockOperations() {
        AesCipherService aes = new AesCipherService();
        byte[] key = aes.generateNewKey().getEncoded();
        for (String plain : PLAINTEXTS) {
            byte[] plaintext = CodecSupport.toBytes((String)plain);
            ByteSource ciphertext = aes.encrypt(plaintext, key);
            ByteSource decrypted = aes.decrypt(ciphertext.getBytes(), key);
            Assert.assertTrue((boolean)Arrays.equals(plaintext, decrypted.getBytes()));
        }
    }

    @Test
    public void testStreamingOperations() {
        AesCipherService cipher = new AesCipherService();
        byte[] key = cipher.generateNewKey().getEncoded();
        for (String plain : PLAINTEXTS) {
            byte[] plaintext = CodecSupport.toBytes((String)plain);
            ByteArrayInputStream plainIn = new ByteArrayInputStream(plaintext);
            ByteArrayOutputStream cipherOut = new ByteArrayOutputStream();
            cipher.encrypt((InputStream)plainIn, (OutputStream)cipherOut, key);
            byte[] ciphertext = cipherOut.toByteArray();
            ByteArrayInputStream cipherIn = new ByteArrayInputStream(ciphertext);
            ByteArrayOutputStream plainOut = new ByteArrayOutputStream();
            cipher.decrypt((InputStream)cipherIn, (OutputStream)plainOut, key);
            byte[] decrypted = plainOut.toByteArray();
            Assert.assertTrue((boolean)Arrays.equals(plaintext, decrypted));
        }
    }
}

