/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.aop.RoleAnnotationHandler;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.test.SecurityManagerTestSupport;
import org.easymock.EasyMock;
import org.junit.Test;

public class RoleAnnotationHandlerTest
extends SecurityManagerTestSupport {
    private Subject subject;

    @Test(expected=UnauthenticatedException.class)
    public void testGuestSingleRoleAssertion() throws Throwable {
        RoleAnnotationHandler handler = new RoleAnnotationHandler();
        RequiresRoles requiresRolesAnnotation = new RequiresRoles(){

            public String[] value() {
                return new String[]{"blah"};
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresRoles.class;
            }

            public Logical logical() {
                return Logical.AND;
            }
        };
        handler.assertAuthorized((Annotation)requiresRolesAnnotation);
    }

    @Test(expected=UnauthenticatedException.class)
    public void testGuestMultipleRolesAssertion() throws Throwable {
        RoleAnnotationHandler handler = new RoleAnnotationHandler();
        RequiresRoles requiresRolesAnnotation = new RequiresRoles(){

            public String[] value() {
                return new String[]{"blah", "blah2"};
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresRoles.class;
            }

            public Logical logical() {
                return Logical.AND;
            }
        };
        handler.assertAuthorized((Annotation)requiresRolesAnnotation);
    }

    @Test
    public void testOneOfTheRolesRequired() throws Throwable {
        this.subject = (Subject)EasyMock.createMock(Subject.class);
        EasyMock.expect((Object)this.subject.hasRole("blah")).andReturn((Object)true);
        EasyMock.expect((Object)this.subject.hasRole("blah2")).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.subject});
        RoleAnnotationHandler handler = new RoleAnnotationHandler(){

            protected Subject getSubject() {
                return RoleAnnotationHandlerTest.this.subject;
            }
        };
        RequiresRoles requiresRolesAnnotation = new RequiresRoles(){

            public String[] value() {
                return new String[]{"blah", "blah2"};
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresRoles.class;
            }

            public Logical logical() {
                return Logical.OR;
            }
        };
        handler.assertAuthorized((Annotation)requiresRolesAnnotation);
    }
}

