/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authz.aop;

import java.lang.annotation.Annotation;
import org.apache.shiro.authz.UnauthenticatedException;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.authz.aop.PermissionAnnotationHandler;
import org.apache.shiro.test.SecurityManagerTestSupport;
import org.junit.Test;

public class PermissionAnnotationHandlerTest
extends SecurityManagerTestSupport {
    @Test(expected=UnauthenticatedException.class)
    public void testGuestSinglePermissionAssertion() throws Throwable {
        PermissionAnnotationHandler handler = new PermissionAnnotationHandler();
        RequiresPermissions requiresPermissionAnnotation = new RequiresPermissions(){

            public String[] value() {
                return new String[]{"test:test"};
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresPermissions.class;
            }

            public Logical logical() {
                return Logical.AND;
            }
        };
        handler.assertAuthorized((Annotation)requiresPermissionAnnotation);
    }

    @Test(expected=UnauthenticatedException.class)
    public void testGuestMultiplePermissionAssertion() throws Throwable {
        PermissionAnnotationHandler handler = new PermissionAnnotationHandler();
        RequiresPermissions requiresPermissionAnnotation = new RequiresPermissions(){

            public String[] value() {
                return new String[]{"test:test", "test2:test2"};
            }

            public Class<? extends Annotation> annotationType() {
                return RequiresPermissions.class;
            }

            public Logical logical() {
                return Logical.AND;
            }
        };
        handler.assertAuthorized((Annotation)requiresPermissionAnnotation);
    }
}

