/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.session.mgt;

import java.io.Serializable;
import org.apache.shiro.session.ExpiredSessionException;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.DelegatingSession;
import org.apache.shiro.session.mgt.NativeSessionManager;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.util.ThreadContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingSessionTest {
    DelegatingSession session = null;
    DefaultSessionManager sm = null;

    @Before
    public void setup() {
        ThreadContext.remove();
        this.sm = new DefaultSessionManager();
        this.session = new DelegatingSession((NativeSessionManager)this.sm, (SessionKey)new DefaultSessionKey(this.sm.start(null).getId()));
    }

    @After
    public void tearDown() {
        this.sm.destroy();
        ThreadContext.remove();
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Test
    public void testTimeout() {
        Serializable origId = this.session.getId();
        Assert.assertEquals((long)this.session.getTimeout(), (long)1800000L);
        this.session.touch();
        this.session.setTimeout(100L);
        Assert.assertEquals((long)100L, (long)this.session.getTimeout());
        this.sleep(150L);
        try {
            this.session.getTimeout();
            Assert.fail((String)"Session should have expired.");
        }
        catch (ExpiredSessionException expiredSessionException) {
            // empty catch block
        }
    }
}

