/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.UUID;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import junit.framework.Assert;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class JndiLdapContextFactoryTest {
    private JndiLdapContextFactory factory;

    @Before
    public void setUp() {
        this.factory = new JndiLdapContextFactory(){

            protected LdapContext createLdapContext(Hashtable env) throws NamingException {
                return (LdapContext)EasyMock.createNiceMock(LdapContext.class);
            }
        };
    }

    @Test(expected=NamingException.class)
    public void testGetLdapContext() throws NamingException {
        this.factory = new JndiLdapContextFactory();
        String brokenHost = UUID.randomUUID().toString();
        this.factory.setUrl("ldap://" + brokenHost + ":389");
        this.factory.getLdapContext((Object)"foo", (Object)"bar");
    }

    @Test
    public void testAuthenticationMechanism() {
        String mech = "MD5-DIGEST";
        this.factory.setAuthenticationMechanism(mech);
        Assert.assertEquals((String)mech, (String)this.factory.getAuthenticationMechanism());
    }

    @Test
    public void testReferral() {
        String referral = "throw";
        this.factory.setReferral(referral);
        Assert.assertEquals((String)referral, (String)this.factory.getReferral());
    }

    @Test
    public void testGetContextFactoryClassName() {
        Assert.assertEquals((String)"com.sun.jndi.ldap.LdapCtxFactory", (String)this.factory.getContextFactoryClassName());
    }

    @Test
    public void testSetEnvironmentPropertyNull() {
        this.factory.setAuthenticationMechanism("MD5-DIGEST");
        this.factory.setAuthenticationMechanism(null);
        Assert.assertNull((Object)this.factory.getAuthenticationMechanism());
    }

    @Test
    public void testCustomEnvironment() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("foo", "bar");
        this.factory.setEnvironment(map);
        Assert.assertEquals((Object)"bar", this.factory.getEnvironment().get("foo"));
    }

    @Test(expected=IllegalStateException.class)
    public void testGetLdapContextWithoutUrl() throws NamingException {
        this.factory.getLdapContext((Object)"foo", (Object)"bar");
    }

    @Test
    public void testGetLdapContextDefault() throws NamingException {
        this.factory = new JndiLdapContextFactory(){

            protected LdapContext createLdapContext(Hashtable env) throws NamingException {
                Assert.assertEquals((Object)"ldap://localhost:389", env.get("java.naming.provider.url"));
                Assert.assertEquals((Object)"foo", env.get("java.naming.security.principal"));
                Assert.assertEquals((Object)"bar", env.get("java.naming.security.credentials"));
                Assert.assertEquals((Object)"simple", env.get("java.naming.security.authentication"));
                Assert.assertNull(env.get("com.sun.jndi.ldap.connect.pool"));
                return (LdapContext)EasyMock.createNiceMock(LdapContext.class);
            }
        };
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getLdapContext((Object)"foo", (Object)"bar");
    }

    @Test
    public void testGetLdapContextStringArguments() throws NamingException {
        this.factory = new JndiLdapContextFactory(){

            protected LdapContext createLdapContext(Hashtable env) throws NamingException {
                Assert.assertEquals((Object)"ldap://localhost:389", env.get("java.naming.provider.url"));
                Assert.assertEquals((Object)"foo", env.get("java.naming.security.principal"));
                Assert.assertEquals((Object)"bar", env.get("java.naming.security.credentials"));
                Assert.assertEquals((Object)"simple", env.get("java.naming.security.authentication"));
                Assert.assertNull(env.get("com.sun.jndi.ldap.connect.pool"));
                return (LdapContext)EasyMock.createNiceMock(LdapContext.class);
            }
        };
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getLdapContext("foo", "bar");
    }

    @Test
    public void testGetSystemLdapContext() throws NamingException {
        this.factory = new JndiLdapContextFactory(){

            protected LdapContext createLdapContext(Hashtable env) throws NamingException {
                Assert.assertEquals((Object)"ldap://localhost:389", env.get("java.naming.provider.url"));
                Assert.assertEquals((Object)"foo", env.get("java.naming.security.principal"));
                Assert.assertEquals((Object)"bar", env.get("java.naming.security.credentials"));
                Assert.assertEquals((Object)"simple", env.get("java.naming.security.authentication"));
                Assert.assertNotNull(env.get("com.sun.jndi.ldap.connect.pool"));
                return (LdapContext)EasyMock.createNiceMock(LdapContext.class);
            }
        };
        this.factory.setSystemUsername("foo");
        this.factory.setSystemPassword("bar");
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getSystemLdapContext();
    }

    @Test
    public void testGetSystemLdapContextPoolingDisabled() throws NamingException {
        this.factory = new JndiLdapContextFactory(){

            protected LdapContext createLdapContext(Hashtable env) throws NamingException {
                Assert.assertEquals((Object)"ldap://localhost:389", env.get("java.naming.provider.url"));
                Assert.assertEquals((Object)"foo", env.get("java.naming.security.principal"));
                Assert.assertEquals((Object)"bar", env.get("java.naming.security.credentials"));
                Assert.assertEquals((Object)"simple", env.get("java.naming.security.authentication"));
                Assert.assertNull(env.get("com.sun.jndi.ldap.connect.pool"));
                return (LdapContext)EasyMock.createNiceMock(LdapContext.class);
            }
        };
        this.factory.setSystemUsername("foo");
        this.factory.setSystemPassword("bar");
        this.factory.setPoolingEnabled(false);
        this.factory.setUrl("ldap://localhost:389");
        this.factory.getSystemLdapContext();
    }
}

