/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.authc.credential;

import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha1Hash;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.junit.Assert;
import org.junit.Test;

public class HashedCredentialsMatcherTest {
    @Test
    public void testSaltedAuthenticationInfo() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        ByteSource salt = new SecureRandomNumberGenerator().nextBytes();
        Sha1Hash hashedPassword = new Sha1Hash((Object)"password", (Object)salt);
        SimpleAuthenticationInfo account = new SimpleAuthenticationInfo((Object)"username", (Object)hashedPassword, salt, "realmName");
        UsernamePasswordToken token = new UsernamePasswordToken("username", "password");
        Assert.assertTrue((boolean)matcher.doCredentialsMatch((AuthenticationToken)token, (AuthenticationInfo)account));
    }

    @Test
    public void testBackwardsCompatibleUnsaltedAuthenticationInfo() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        String username = "username";
        String password = "password";
        final byte[] hashedPassword = new Sha1Hash((Object)"password").getBytes();
        AuthenticationInfo account = new AuthenticationInfo(){

            public PrincipalCollection getPrincipals() {
                return new SimplePrincipalCollection((Object)"username", "realmName");
            }

            public Object getCredentials() {
                return hashedPassword;
            }
        };
        UsernamePasswordToken token = new UsernamePasswordToken("username", "password");
        Assert.assertTrue((boolean)matcher.doCredentialsMatch((AuthenticationToken)token, account));
    }

    @Test
    public void testBackwardsCompatibleSaltedAuthenticationInfo() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        matcher.setHashSalted(true);
        String username = "username";
        String password = "password";
        final byte[] hashedPassword = new Sha1Hash((Object)"password", (Object)"username").getBytes();
        AuthenticationInfo account = new AuthenticationInfo(){

            public PrincipalCollection getPrincipals() {
                return new SimplePrincipalCollection((Object)"username", "realmName");
            }

            public Object getCredentials() {
                return hashedPassword;
            }
        };
        UsernamePasswordToken token = new UsernamePasswordToken("username", "password");
        Assert.assertTrue((boolean)matcher.doCredentialsMatch((AuthenticationToken)token, account));
    }
}

