/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.aop;

import java.lang.reflect.Method;
import org.apache.shiro.aop.DefaultAnnotationResolver;
import org.apache.shiro.aop.MethodInvocation;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.apache.shiro.authz.annotation.RequiresUser;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationResolverTest {
    DefaultAnnotationResolver annotationResolver = new DefaultAnnotationResolver();

    @Test
    public void testAnnotationFoundFromClass() throws SecurityException, NoSuchMethodException {
        MyFixture myFixture = new MyFixture();
        MethodInvocation methodInvocation = (MethodInvocation)EasyMock.createMock(MethodInvocation.class);
        Method method = MyFixture.class.getDeclaredMethod("operateThis", new Class[0]);
        EasyMock.expect((Object)methodInvocation.getMethod()).andReturn((Object)method);
        EasyMock.expect((Object)methodInvocation.getThis()).andReturn((Object)myFixture);
        EasyMock.replay((Object[])new Object[]{methodInvocation});
        Assert.assertNotNull((Object)this.annotationResolver.getAnnotation(methodInvocation, RequiresRoles.class));
    }

    @Test
    public void testAnnotationFoundFromMethod() throws SecurityException, NoSuchMethodException {
        MethodInvocation methodInvocation = (MethodInvocation)EasyMock.createMock(MethodInvocation.class);
        Method method = MyFixture.class.getDeclaredMethod("operateThat", new Class[0]);
        EasyMock.expect((Object)methodInvocation.getMethod()).andReturn((Object)method);
        EasyMock.replay((Object[])new Object[]{methodInvocation});
        Assert.assertNotNull((Object)this.annotationResolver.getAnnotation(methodInvocation, RequiresUser.class));
    }

    @RequiresRoles(value={"root"})
    private class MyFixture {
        private MyFixture() {
        }

        public void operateThis() {
        }

        @RequiresUser
        public void operateThat() {
        }
    }
}

